package com.alibaba.tesla.dag.model.domain.dag;

import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.alibaba.tesla.dag.model.domain.ParamType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.ParamFromType;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author jinghua.yjh
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DagInputParam {

    String name;
    String alias;
    Object value;
    ParamType type;
    Boolean isOverWrite;

    public DagNodeInputParam toDagNodeInputParam() {
        return DagNodeInputParam.builder()
            .name(name)
            .alias(alias)
            .value(value)
            .type(type)
            .isOverWrite(isOverWrite)
            .fromType(ParamFromType.CONSTANT)
            .from("")
            .build();
    }

    public Object value() throws Exception {
        if (value == null) {
            return null;
        }
        try {
            switch (type) {
                case STRING:
                    return TypeUtils.castToJavaBean(value, String.class);
                case OBJECT:
                    return TypeUtils.castToJavaBean(value, JSONObject.class);
                case FLOAT:
                    return TypeUtils.castToJavaBean(value, Float.class);
                case ARRAY:
                    return TypeUtils.castToJavaBean(value, JSONArray.class);
                case LONG:
                    return TypeUtils.castToJavaBean(value, Long.class);
                case BOOLEAN:
                    return TypeUtils.castToJavaBean(value, Boolean.class);
                default:
                    return value;
            }
        } catch (Exception e) {
            throw new Exception("value can not match type", e);
        }
    }

    public void check() throws Exception {
        value();
    }

    public static void check(List<DagInputParam> inputParamList) throws Exception {
        for (DagInputParam inputParam : inputParamList) {
            inputParam.check();
        }
    }
}
