package com.alibaba.tesla.dag.model.domain.dagnode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.ParamType;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;

import com.alibaba.tesla.dag.services.AbstractActionNewService;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Builder.Default;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import static com.alibaba.tesla.dag.model.domain.dagnode.ParamFromType.CONSTANT;

/**
 * @author jinghua.yjh
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Slf4j
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DagNodeInputParam extends DagNodeParam {

    String name;
    String alias;
    Object value;
    ParamType type;
    Boolean isOverWrite;
    @Default
    ParamFromType fromType = CONSTANT;
    String from;

    public DagInputParam toDagInputParam() {
        return DagInputParam.builder()
            .name(name)
            .alias(alias)
            .value(value)
            .type(type)
            .isOverWrite(isOverWrite)
            .build();
    }

    public void setValue(JSONObject jsonObject) {
        String name = (String)this.value;
        if (StringUtils.isEmpty(name)) {
            name = this.name;
        }
        switch (type) {
            case BOOLEAN:
                value = jsonObject.getBooleanValue(name);
                break;
            case LONG:
                value = jsonObject.getLongValue(name);
                break;
            case ARRAY:
                value = jsonObject.getJSONArray(name);
                break;
            case FLOAT:
                value = jsonObject.getFloatValue(name);
                break;
            case OBJECT:
                value = jsonObject.getJSONObject(name);
                break;
            case STRING:
                value = jsonObject.getString(name);
                break;
            default:
                value = null;
                break;
        }
    }

    public static Map<String, Object> toMap(List<DagNodeInputParam> dagNodeInputParamList) {
        Map<String, Object> map = new HashMap<>(0);
        for (DagNodeInputParam dagNodeInputParam : dagNodeInputParamList) {
            map.put(dagNodeInputParam.getName(), dagNodeInputParam.getValue());
        }
        return map;
    }

    public static JSONObject toJson(List<DagNodeInputParam> dagNodeInputParamList) {
        return JSONObject.parseObject(JSONObject.toJSONString(toMap(dagNodeInputParamList)));
    }

    public static void setValue(List<DagNodeInputParam> dagNodeInputParamList, JSONObject globalVariableJson,
        JSONObject globalResultJson) {

        for (DagNodeInputParam dagNodeInputParam : dagNodeInputParamList) {
            switch (dagNodeInputParam.getFromType()) {
                case FATHER_NODE:
                    JSONObject jsonObject = globalResultJson.getJSONObject(dagNodeInputParam.getFrom());
                    jsonObject = jsonObject == null ? new JSONObject() : jsonObject;
                    jsonObject = jsonObject.getJSONObject(AbstractActionNewService.OUTPUT_DATA_OUTPUT_KEY);
                    dagNodeInputParam.setValue(jsonObject);
                    break;
                case GLOBAL_VARIABLE:
                    dagNodeInputParam.setValue(globalVariableJson);
                    break;
                case CONSTANT:
                default:
                    break;
            }
        }

    }

    public static List<DagNodeInputParam> toList(JSONArray inputParamArray) {
        inputParamArray = inputParamArray == null ? new JSONArray() : inputParamArray;
        List<DagNodeInputParam> dagNodeInputParamList = new ArrayList<>();
        for (JSONObject jsonObject : inputParamArray.toJavaList(JSONObject.class)) {
            String name = jsonObject.getString("name");
            String alias = jsonObject.getString("alias");
            Boolean isOverWrite = jsonObject.getBoolean("isOverWrite");
            String type = null;
            if (jsonObject.get("type") != null) {
                type = jsonObject.getString("type");
            }else  {
                //加一个默认值
                log.info("typeIsEmpty, data={}", JSONObject.toJSONString(jsonObject));
                type = "STRING";
            }
            dagNodeInputParamList.add(DagNodeInputParam.builder()
                .name(name)
                .alias(StringUtils.isEmpty(alias) ? name : alias)
                .value(jsonObject.get("value"))
                .type(ParamType.valueOf(type.toUpperCase()))
                .isOverWrite(isOverWrite == null ? true : isOverWrite)
                .from(jsonObject.getString("from"))
                .fromType(StringUtils.isEmpty(jsonObject.getString("fromType")) ?
                    CONSTANT : ParamFromType.valueOf(jsonObject.getString("fromType")))
                .build());
        }
        return dagNodeInputParamList;
    }

}
