package com.alibaba.tesla.dag.model.domain.dagnode;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.ParamType;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @author jinghua.yjh
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Slf4j
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DagNodeOutputParam extends DagNodeParam{

    String name;
    String alias;
    ParamType type;

    public static List<DagNodeOutputParam> toList(JSONArray outputParamArray) {
        outputParamArray = outputParamArray == null ? new JSONArray() : outputParamArray;
        List<DagNodeOutputParam> dagNodeOutputParamList = new ArrayList<>();
        for (JSONObject jsonObject : outputParamArray.toJavaList(JSONObject.class)) {
            String name = jsonObject.getString("name");
            String alias = jsonObject.getString("alias");

            dagNodeOutputParamList.add(DagNodeOutputParam.builder()
                .name(name)
                .alias(StringUtils.isEmpty(alias) ? name : alias)
                .type(ParamType.valueOf(jsonObject.getString("type").toUpperCase()))
                .build());
        }
        return dagNodeOutputParamList;
    }

}
