package com.alibaba.tesla.dag.model.repository;

import java.util.List;

import com.alibaba.tesla.dag.model.domain.TcDagConfig;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.TcDagInstEdge;
import com.alibaba.tesla.dag.model.domain.TcDagInstNode;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author jinghua.yjh
 */
public interface TcDagInstEdgeRepository
    extends JpaRepository<TcDagInstEdge, Long>, JpaSpecificationExecutor<TcDagInstEdge> {

    List<TcDagInstEdge> findAllByDagInstId(Long dagInstId);

    List<TcDagInstEdge> findAllByDagInstIdAndTarget(Long dagInstId, String target);

    TcDagInstEdge findFirstByDagInstIdAndSourceAndTarget(Long dagInstId, String source, String target);

    TcDagInstEdge findFirstById(Long id);

    boolean existsById(Long id);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value="DELETE FROM tc_dag_inst_edge WHERE gmt_create < ?1 LIMIT 2000", nativeQuery = true)
    int deleteByGmtCreate(Long gmtCreate);
}
