package com.alibaba.tesla.dag.model.repository;

import com.alibaba.tesla.dag.model.domain.TcDagInstNode;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author jinghua.yjh
 */
@Transactional(rollbackFor = Exception.class)
public interface TcDagInstNodeRepository
        extends JpaRepository<TcDagInstNode, Long>, JpaSpecificationExecutor<TcDagInstNode> {

    TcDagInstNode findFirstById(Long id);

    TcDagInstNode findFirstBySubDagInstId(Long subDagInstId);

    List<TcDagInstNode> findAllByDagInstIdAndNodeIdNotIn(Long dagInstId, List<String> nodeIdList);

    List<TcDagInstNode> findAllByDagInstIdAndNodeIdNotInAndStatusIn(Long dagInstId, List<String> nodeIdList,
                                                                    List<String> statusList);

    List<TcDagInstNode> findAllByDagInstIdAndNodeIdNotInOrderByGmtStartAsc(Long dagInstId, List<String> nodeIdList);

    List<TcDagInstNode> findAllByDagInstIdAndNodeIdInOrderByGmtStartAsc(Long dagInstId, List<String> nodeIdList);

    List<TcDagInstNode> findAllByDagInstIdAndStatusIn(Long dagInstId, List<String> statusList);

    List<TcDagInstNode> findAllByDagInstId(Long dagInstId);

    List<TcDagInstNode> findAllByStatus(String status);

    List<TcDagInstNode> findAllByDagInstIdOrderByGmtStartAsc(Long dagInstId);

    TcDagInstNode findFirstByDagInstIdAndNodeId(Long dagInstId, String nodeId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " "
            + " update "
            + " tc_dag_inst_node "
            + " set status = ?1 "
            + " where status in ?2 and dag_inst_id=?3",
            nativeQuery = true)
    int updateStatus(String newStatus, List<String> oldStatusList, long dagInstId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " "
            + " update "
            + " tc_dag_inst_node "
            + " set status = ?1 "
            + " where id=?3",
            nativeQuery = true)
    int updateStatusById(String newStatus, long id);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "DELETE FROM tc_dag_inst_node WHERE gmt_create < ?1 LIMIT 2000", nativeQuery = true)
    int deleteByGmtCreate(Long gmtCreate);
}

