package com.alibaba.tesla.dag.model.repository;

import java.util.List;

import com.alibaba.tesla.dag.model.domain.TcDagConfig;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.TcDagInstNodeStd;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author jinghua.yjh
 */
public interface TcDagInstNodeStdRepository
    extends JpaRepository<TcDagInstNodeStd, Long>, JpaSpecificationExecutor<TcDagInstNodeStd> {

    TcDagInstNodeStd findFirstById(Long id);

    boolean existsById(Long id);

    @Query(value = " "
        + " select status from "
        + " tc_dag_inst_node_std "
        + " where id = ?1 "
        + " limit 1 ",
        nativeQuery = true)
    String getStatus(Long id);

    @Query(value = " "
        + " select ip from "
        + " tc_dag_inst_node_std "
        + " where id = ?1 "
        + " limit 1 ",
        nativeQuery = true)
    String getIp(Long id);

    List<TcDagInstNodeStd> findAllByStatusInAndIp(List<String> statusList, String ip);

    TcDagInstNodeStd findFirstByLockId(String lockId);

    @Query(value = " "
        + " select id from "
        + " tc_dag_inst_node_std "
        + " where "
        + "     status = ?1 "
        + "     and "
        + "     (lock_id = '' or lock_id is null or (gmt_access < ?3 - 30)) "
        + "     and "
        + "     (ip = '' or ip is null or ip = ?2) "
        + " order by gmt_access asc "
        + " limit 1 ",
        nativeQuery = true)
    Long findIdForLock(String status, String localIp, long timestamp);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " "
        + " update "
        + " tc_dag_inst_node_std "
        + " set lock_id = ?1, gmt_access = ?5, ip=?4 "
        + " where "
        + "     status = ?2 "
        + "     and "
        + "     (lock_id = '' or lock_id is null or (gmt_access < ?5 - 30)) "
        + "     and "
        + "     id = ?3 "
        //+ " order by gmt_access asc "
        //+ " limit 1 "
        ,
        nativeQuery = true)
    int lockOne(String lockId, String status, Long id, String localIp, long timestamp);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " update tc_dag_inst_node_std set lock_id = '' where id = ?1 ", nativeQuery = true)
    int release(Long id);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " "
        + " select id from tc_dag_inst_node_std "
        + " where "
        + "     gmt_access < ?2 - 60 "
        + "     and "
        + "     (standalone_ip = '' or standalone_ip is null) "
        + "     and "
        + "     (status in ?1) "
        , nativeQuery = true)
    List<Long> findAllIdForReInit(List<String> statusList, long timestamp);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " "
        + " update tc_dag_inst_node_std "
        + " set "
        + "     lock_id = '' "
        + "     , status = 'INIT' "
        + "     , gmt_access = ?2 "
        + "     , gmt_modified = ?2 "
        + "     , ip = '' "
        + " where "
        + "     gmt_access < ?2 - 60 "
        + "     and "
        + "     (standalone_ip = '' or standalone_ip is null) "
        + "     and "
        + "     (status in ?1) "
        + "     and "
        + "     id = ?3 "
        , nativeQuery = true)
    int reInit(List<String> statusList, long timestamp, Long id);

    @Query(value = " "
        + " select id from tc_dag_inst_node_std "
        + " where "
        + "     gmt_access < ?2 - 60 "
        + "     and "
        + "     (standalone_ip != '' and standalone_ip is not null) "
        + "     and "
        + "     (status in ?1) "
        , nativeQuery = true)
    List<Long> findAllIdForReException(List<String> statusList, long timestamp);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " "
        + " update tc_dag_inst_node_std "
        + " set "
        + "     lock_id = '' "
        + "     , status = 'EXCEPTION' "
        + "     , gmt_access = ?2 "
        + "     , gmt_modified = ?2 "
        + " where "
        + "     gmt_access < ?2 - 60 "
        + "     and "
        + "     (standalone_ip != '' and standalone_ip is not null) "
        + "     and "
        + "     (status in ?1) "
        + "     and "
        + "     id = ?3 "
        , nativeQuery = true)
    int reException(List<String> statusList, long timestamp, Long id);

    @Query(value = " "
        + " select id from tc_dag_inst_node_std "
        + " where "
        + "     status = 'WAIT' "
        + "     and "
        + "     dag_inst_id = ?1 "
        , nativeQuery = true)
    List<Long> findAllIdForInitWait(Long dagInstId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " "
        + " update tc_dag_inst_node_std "
        + " set "
        + "     status = 'INIT' "
        + " where "
        + "     status = 'WAIT' "
        + "     and "
        + "     dag_inst_id = ?1 "
        + "     and "
        + "     id = ?2"
        , nativeQuery = true)
    int initWait(Long dagInstId, Long id);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value="DELETE FROM tc_dag_inst_node_std WHERE gmt_create < ?1 LIMIT 2000", nativeQuery = true)
    int deleteByGmtCreate(Long gmtCreate);
}
