package com.alibaba.tesla.dag.model.repository;

import com.alibaba.tesla.dag.model.domain.TcDagInst;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author jinghua.yjh
 */
@Transactional(rollbackFor = Exception.class)
public interface TcDagInstRepository extends JpaRepository<TcDagInst, Long>, JpaSpecificationExecutor<TcDagInst> {
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " update tc_dag_inst set global_variable = ?2 where id = ?1 ", nativeQuery = true)
    int updateGlobalVariable(Long id, String globalVariable);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " update tc_dag_inst set status = ?2 where id = ?1 ", nativeQuery = true)
    int updateStatus(Long id, String status);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = " "
            + " update "
            + " tc_dag_inst "
            + " set status = ?1 "
            + " where id=?2",
            nativeQuery = true)
    int setStatus(String newStatus, long id);

    TcDagInst findFirstByDagIdAndStatusOrderByGmtCreateDesc(Long dagId, String status);

    TcDagInst findFirstByDagIdAndTagOrderByGmtCreateDesc(Long dagId, String tag);

    List<TcDagInst> findAllByDagIdAndTagOrderByGmtCreateDesc(Long dagId, String tag, Pageable pageable);

    List<TcDagInst> findAllByDagIdAndStatusInOrderByGmtCreateDesc(Long dagId, List<String> statusList,
                                                                  Pageable pageable);

    int countByDagIdAndStatusIn(Long dagId, List<String> statusList);

    TcDagInst findFirstById(Long id);

    List<TcDagInst> findAllByStatus(String status);

    boolean existsById(Long id);

    @Modifying
    @Query(value = "DELETE FROM tc_dag_inst WHERE gmt_create < ?1 LIMIT 2000", nativeQuery = true)
    int deleteByGmtCreate(Long gmtCreate);
}
