package com.alibaba.tesla.dag.model.repository;

import com.alibaba.tesla.dag.model.domain.TcDagNode;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author jinghua.yjh
 */
public interface TcDagNodeRepository
        extends JpaRepository<TcDagNode, Long>, JpaSpecificationExecutor<TcDagNode> {

    TcDagNode findFirstById(Long id);

    boolean existsById(Long id);

    @Transactional(rollbackFor = Exception.class)
    int deleteByAppIdAndName(String appId, String name);

    List<TcDagNode> findAllByAppId(String appId);

    List<TcDagNode> findAllByLastUpdateBy(String lastUpdateBy);

    TcDagNode findFirstByAppIdAndName(String appId, String name);

    @Modifying
    @Transactional(rollbackFor = Exception.class)
    void deleteByNameNotInAndLastUpdateBy(List<String> nameList, String lastUpdateBy);

}
