package com.alibaba.tesla.dag.model.repository;

import com.alibaba.tesla.dag.model.domain.TcDag;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author jinghua.yjh
 */
public interface TcDagRepository extends JpaRepository<TcDag, Long>, JpaSpecificationExecutor<TcDag> {

    TcDag findFirstById(Long id);

    boolean existsById(Long id);

    boolean existsByAppIdAndName(String appId, String name);

    @Transactional(rollbackFor = Exception.class)
    int deleteByAppIdAndName(String appId, String name);

    TcDag findFirstByAppIdAndName(String appId, String name);

    List<TcDag> findAllByAppId(String appId);

    List<TcDag> findAllByLastUpdateBy(String lastUpdateBy);

    @Modifying
    @Transactional(rollbackFor = Exception.class)
    void deleteByNameNotInAndLastUpdateBy(List<String> nameList, String lastUpdateBy);
}
