package com.alibaba.tesla.dag.notify.impl;

import com.alibaba.tesla.dag.notify.DagInstNodeTask;
import com.alibaba.tesla.dag.notify.IDagInstNodeTaskNotify;
import com.alibaba.tesla.dag.services.AsyncService;
import com.alibaba.tesla.dag.services.LockService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@Lazy
@ConditionalOnProperty(name = "dag.usage.mode", havingValue = "jar")
public class LocalDagInstNodeTaskNotify implements IDagInstNodeTaskNotify {
    @Autowired
    private AsyncService asyncService;

    @Autowired
    private LockService lockService;

    @Override
    public void sendDagInstNodeTask(DagInstNodeTask dagInstNodeTask) {
        String key = dagInstNodeTask.fetchKey();

        if (!lockService.tryLock(key)) {
            log.info(">>>localDagInstNodeTaskNotify|sendDagInstNodeTask|already exists|key={}", key);
            return;
        }
        asyncService.doDagInstNodeTask(dagInstNodeTask);
    }
}
