package com.alibaba.tesla.dag.notify.impl;

import com.alibaba.tesla.dag.notify.DagInstDispatch;
import com.alibaba.tesla.dag.notify.IDagInstNotify;
import com.alibaba.tesla.dag.services.AsyncService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@Lazy
@ConditionalOnProperty(name = "dag.usage.mode", havingValue = "jar")
public class LocalDagInstNotify implements IDagInstNotify {
    @Autowired
    private AsyncService asyncService;

    @Override
    public void sendDagInstDispatch(DagInstDispatch dagInstDispatch) {
        asyncService.doDagInstDispatch(dagInstDispatch);
    }
}
