package com.alibaba.tesla.dag.provider.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.provider.DagInstProvider;
import com.alibaba.tesla.dag.repository.domain.DagDO;
import com.alibaba.tesla.dag.services.DagInstNewService;
import com.alibaba.tesla.dag.services.DagNewService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author QianMo
 * @date 2021/04/21.
 */
@Slf4j
@Service
public class DagInstProviderImpl implements DagInstProvider {
    @Autowired
    private DagNewService dagNewService;

    @Autowired
    private DagInstNewService dagInstNewService;

    @Override
    public Long submit(String appId, String operator, String channel, String env, JSONObject commonParams, boolean isStandalone)
            throws Exception {
        log.info(">>>dagInstProvider|submit|enter|appId={}, operator={}, channel={}, env={}, commonParams={}, isStandalone={}", appId,
                operator, channel, env, commonParams, isStandalone);

        String nameEn = commonParams.getString("nameEn");

        DagDO dagDO = dagNewService.getDag(appId, nameEn);
        if (Objects.isNull(dagDO)) {
            log.warn(">>>dagInstProvider|submit|dag does not exist|appId={}, name={}", appId, nameEn);
            throw new Exception("dag does not exist!appId=" + appId + ", name=" + nameEn);
        }

        return dagInstNewService.submit(dagDO, operator, channel, env, commonParams, isStandalone);
    }
}
