package com.alibaba.tesla.dag.repository.dao;

import java.util.List;

import com.alibaba.tesla.dag.repository.domain.DagInstEdgeDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.repository.mapper.DagBatchMapper;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * @author QianMo
 * @date 2021/04/29.
 */
@Repository
public class DagBatchDAO {
    @Autowired
    private DagBatchMapper batchMapper;

    public int batchInsertNode(List<DagInstNodeDO> dagInstNodeDOList) {
        if (CollectionUtils.isEmpty(dagInstNodeDOList)) {
            return 0;
        }
        return batchMapper.batchInsertNode(dagInstNodeDOList);
    }

    public int batchInsertEdge(List<DagInstEdgeDO> dagInstEdgeDOList) {
        if (CollectionUtils.isEmpty(dagInstEdgeDOList)) {
            return 0;
        }
        return batchMapper.batchInsertEdge(dagInstEdgeDOList);
    }
}
