package com.alibaba.tesla.dag.repository.dao;

import java.util.List;

import com.alibaba.tesla.dag.repository.domain.DagDO;
import com.alibaba.tesla.dag.repository.domain.DagDOExample;
import com.alibaba.tesla.dag.repository.mapper.DagDOMapper;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * @author QianMo
 * @date 2021/04/22.
 */
@Repository
public class DagDAO {
    @Autowired
    private DagDOMapper dagDOMapper;

    public DagDO getDag(String appId, String name) {
        DagDOExample example = new DagDOExample();
        DagDOExample.Criteria criteria = example.createCriteria();
        criteria.andAppIdEqualTo(appId);
        criteria.andNameEqualTo(name);

        List<DagDO> dagDOList = dagDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagDOList)) {
            return dagDOList.get(0);
        }

        return null;
    }

    public DagDO getDagById(Long id) {
        DagDOExample example = new DagDOExample();
        DagDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);

        List<DagDO> dagDOList = dagDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagDOList)) {
            return dagDOList.get(0);
        }

        return null;
    }
}
