package com.alibaba.tesla.dag.repository.dao;

import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.common.Tools;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstDOExample;
import com.alibaba.tesla.dag.repository.mapper.DagInstDOMapper;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.util.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author QianMo
 * @date 2021/04/22.
 */
@Repository
@Slf4j
public class DagInstDAO {
    private static List<String> UN_END_STATUS_LIST = Arrays.asList(DagInstStatus.INIT.toString(),
            DagInstStatus.PRE_RUNNING.toString(), DagInstStatus.RUNNING.toString(),
            DagInstStatus.POST_RUNNING.toString(),
            DagInstStatus.WAIT_STOP.toString(), DagInstStatus.STOPPING.toString());

    @Autowired
    private DagInstDOMapper dagInstDOMapper;

    @Autowired
    private ApplicationProperties applicationProperties;

    public List<DagInstDO> listTimeOut(Long begin, Long end) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andGmtAccessBetween(begin, end);
        criteria.andStatusIn(UN_END_STATUS_LIST);
        if (applicationProperties.isJarUseMode()) {
            criteria.andStandaloneIpEqualTo(Tools.localIp);
        }

        List<DagInstDO> dagInstDOList = dagInstDOMapper.selectByExampleWithBLOBs(example);
        return dagInstDOList;
    }

    public long count(Long dagId, String status) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andDagIdEqualTo(dagId);
        if (StringUtils.isNotEmpty(status)) {
            criteria.andStatusEqualTo(status);
        }

        return dagInstDOMapper.countByExample(example);
    }

    public int insert(DagInstDO dagInstDO) {
        dagInstDO.setGmtCreate(DateUtil.currentSeconds());
        dagInstDO.setGmtModified(DateUtil.currentSeconds());
        dagInstDO.setGmtAccess(DateUtil.currentSeconds());
        dagInstDO.setVersion(0);
        return dagInstDOMapper.insertSelective(dagInstDO);
    }

    public DagInstDO getDagInstById(Long id) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);

        List<DagInstDO> dagInstDOList = dagInstDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagInstDOList)) {
            return dagInstDOList.get(0);
        }

        return null;
    }

    public DagInstDO getDagInstById(Long id, DagInstStatus dagInstStatus) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        criteria.andStatusEqualTo(dagInstStatus.toString());

        List<DagInstDO> dagInstDOList = dagInstDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagInstDOList)) {
            return dagInstDOList.get(0);
        }

        return null;
    }

    public int update(DagInstDO dagInstDO) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(dagInstDO.getId());

        dagInstDO.setGmtModified(DateUtil.currentSeconds());
        dagInstDO.setGmtAccess(DateUtil.currentSeconds());
        return dagInstDOMapper.updateByExampleSelective(dagInstDO, example);
    }

    public int updateWithVersion(DagInstDO dagInstDO) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(dagInstDO.getId());
        criteria.andVersionLessThan(dagInstDO.getVersion());

        dagInstDO.setGmtModified(DateUtil.currentSeconds());
        dagInstDO.setGmtAccess(DateUtil.currentSeconds());
        return dagInstDOMapper.updateByExampleSelective(dagInstDO, example);
    }

    public int updateStatus(Long id, DagInstStatus fromStatus, DagInstStatus toStatus) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        criteria.andStatusEqualTo(fromStatus.toString());

        int count = dagInstDOMapper.updateByExampleSelective(DagInstDO.builder()
                        .status(toStatus.toString())
                        .gmtModified(DateUtil.currentSeconds())
                        .gmtAccess(DateUtil.currentSeconds()).build(),
                example);

        log.info(">>>dagInstDAO|updateStatus|{}|dagInstId={}, fromStatus={}, toStatus={}",
                Objects.equals(count, 0) ? "FAILED" : "SUCCESS",
                id, fromStatus, toStatus);

        return count;
    }

    public int updateStatusWithDetail(Long id, DagInstStatus toStatus, String statusDetail) {
        DagInstDOExample example = new DagInstDOExample();
        DagInstDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);

        return dagInstDOMapper.updateByExampleSelective(DagInstDO.builder().status(toStatus.toString())
                        .statusDetail(statusDetail)
                        .gmtAccess(DateUtil.currentSeconds())
                        .gmtModified(
                                DateUtil.currentSeconds()).build(),
                example);
    }
}
