package com.alibaba.tesla.dag.repository.dao;

import java.util.List;

import com.alibaba.tesla.dag.repository.domain.DagInstEdgeDO;
import com.alibaba.tesla.dag.repository.domain.DagInstEdgeDOExample;
import com.alibaba.tesla.dag.repository.mapper.DagInstEdgeDOMapper;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * @author QianMo
 * @date 2021/04/23.
 */
@Repository
public class DagInstEdgeDAO {
    @Autowired
    private DagInstEdgeDOMapper dagInstEdgeDOMapper;

    public List<DagInstEdgeDO> getSimpleList(Long dagInstId) {
        DagInstEdgeDOExample example = new DagInstEdgeDOExample();
        DagInstEdgeDOExample.Criteria criteria = example.createCriteria();
        criteria.andDagInstIdEqualTo(dagInstId);

        List<DagInstEdgeDO> dagInstEdgeDOList = dagInstEdgeDOMapper.selectByExample(example);
        return dagInstEdgeDOList;
    }

    public List<DagInstEdgeDO> getList(Long dagInstId) {
        DagInstEdgeDOExample example = new DagInstEdgeDOExample();
        DagInstEdgeDOExample.Criteria criteria = example.createCriteria();
        criteria.andDagInstIdEqualTo(dagInstId);

        List<DagInstEdgeDO> dagInstEdgeDOList = dagInstEdgeDOMapper.selectByExampleWithBLOBs(example);
        return dagInstEdgeDOList;
    }

    public int update(DagInstEdgeDO dagInstEdgeDO) {
        DagInstEdgeDOExample example = new DagInstEdgeDOExample();
        DagInstEdgeDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(dagInstEdgeDO.getId());

        return dagInstEdgeDOMapper.updateByExampleSelective(dagInstEdgeDO, example);
    }

    public int insert(DagInstEdgeDO dagInstEdgeDO) {
        return dagInstEdgeDOMapper.insertSelective(dagInstEdgeDO);
    }
}
