package com.alibaba.tesla.dag.repository.dao;

import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.common.Tools;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeStdDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeStdDOExample;
import com.alibaba.tesla.dag.repository.mapper.DagInstNodeStdDOMapper;
import com.alibaba.tesla.dag.schedule.task.TaskStatus;
import com.alibaba.tesla.dag.util.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author QianMo
 * @date 2021/04/23.
 */
@Repository
@Slf4j
public class DagInstNodeStdDAO {
    public static List<String> UN_END_STATUS_LIST = Arrays.asList(TaskStatus.INIT.toString(),
            TaskStatus.RUNNING.toString());

    @Autowired
    private DagInstNodeStdDOMapper dagInstNodeStdDOMapper;

    @Autowired
    private ApplicationProperties applicationProperties;

    public int insert(DagInstNodeStdDO dagInstNodeStdDO) {
        dagInstNodeStdDO.setGmtCreate(DateUtil.currentSeconds());
        dagInstNodeStdDO.setGmtModified(DateUtil.currentSeconds());
        dagInstNodeStdDO.setGmtAccess(DateUtil.currentSeconds());
        return dagInstNodeStdDOMapper.insertSelective(dagInstNodeStdDO);
    }

    public DagInstNodeStdDO getDagInstNodeStdById(Long id) {
        DagInstNodeStdDOExample example = new DagInstNodeStdDOExample();
        DagInstNodeStdDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);

        List<DagInstNodeStdDO> dagInstNodeStdDOList = dagInstNodeStdDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagInstNodeStdDOList)) {
            return dagInstNodeStdDOList.get(0);
        }

        return null;
    }

    public int update(DagInstNodeStdDO dagInstNodeStdDO) {
        DagInstNodeStdDOExample example = new DagInstNodeStdDOExample();
        DagInstNodeStdDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(dagInstNodeStdDO.getId());

        if(StringUtils.equals(dagInstNodeStdDO.getStatus(), TaskStatus.EXCEPTION.toString())){
            log.warn(">>>dagInstNodeStdDAO|update|taskStatus is Exception|localTaskId={}", dagInstNodeStdDO.getId());
        }

        dagInstNodeStdDO.setGmtModified(DateUtil.currentSeconds());

        return dagInstNodeStdDOMapper.updateByExampleSelective(dagInstNodeStdDO, example);
    }

    public int updateStatusWithDetail(Long id, TaskStatus toStatus, String statusDetail) {
        DagInstNodeStdDOExample example = new DagInstNodeStdDOExample();
        DagInstNodeStdDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);

        if(toStatus == TaskStatus.EXCEPTION){
            log.warn(">>>dagInstNodeStdDAO|updateStatusWithDetail|taskStatus is Exception|localTaskId={}", id);
        }

        return dagInstNodeStdDOMapper.updateByExampleSelective(DagInstNodeStdDO.builder().status(toStatus.toString())
                        .stderr(statusDetail)
                        .gmtModified(
                                DateUtil.currentSeconds()).build(),
                example);
    }

    public List<DagInstNodeStdDO> listTimeOut(Long begin, Long end) {
        DagInstNodeStdDOExample example = new DagInstNodeStdDOExample();
        DagInstNodeStdDOExample.Criteria criteria = example.createCriteria();
        criteria.andGmtAccessBetween(begin, end);
        criteria.andLockIdLike("V2_%");

        criteria.andStatusIn(UN_END_STATUS_LIST);
        if (applicationProperties.isJarUseMode()) {
            criteria.andStandaloneIpEqualTo(Tools.localIp);
        }

        return dagInstNodeStdDOMapper.selectByExample(example);
    }
}
