package com.alibaba.tesla.dag.repository.dao;

import java.util.List;

import com.alibaba.tesla.dag.repository.domain.DagNodeDO;
import com.alibaba.tesla.dag.repository.domain.DagNodeDOExample;
import com.alibaba.tesla.dag.repository.mapper.DagNodeDOMapper;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * @author QianMo
 * @date 2021/04/23.
 */
@Repository
public class DagNodeDAO {
    @Autowired
    private DagNodeDOMapper dagNodeDOMapper;

    public DagNodeDO getDagNodeById(Long id) {
        DagNodeDOExample example = new DagNodeDOExample();
        DagNodeDOExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);

        List<DagNodeDO> dagNodeDOList = dagNodeDOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isNotEmpty(dagNodeDOList)) {
            return dagNodeDOList.get(0);
        }

        return null;
    }
}
