package com.alibaba.tesla.dag.repository.domain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.algorithm.DAG;
import com.alibaba.tesla.dag.model.domain.ParamType;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.ParamFromType;
import com.alibaba.tesla.dag.util.DagUtil;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Slf4j
public class DagDO {
    private Long id;

    private Long gmtCreate;

    private Long gmtModified;

    private String appId;

    private String name;

    private String alias;

    private Boolean hasFeedback;

    private Boolean hasHistory;

    private String notice;

    private String creator;

    private String modifier;

    private String lastUpdateBy;

    private String exScheduleTaskId;

    private Boolean defaultShowHistory;

    private String content;

    private String inputParams;

    private String description;

    private String entity;

    private JSONObject contentJson;

    public static void main(String[] args) throws Exception {
        DagDO dagDO1 = new DagDO();
        dagDO1.setInputParams("null");
        log.info("{}", dagDO1.fetchInputParamList());
        String content = "{\n"
                + "  \"nodes\": [\n"
                + "    {\n"
                + "      \"shape\": \"rect\",\n"
                + "      \"data\": {\n"
                + "        \"defId\": 188491,\n"
                + "        \"outputParams\": [],\n"
                + "        \"tooltip\": {},\n"
                + "        \"inputParams\": [],\n"
                + "        \"id\": \"FlinkAsiJobResource\",\n"
                + "        \"label\": \"作业资源\",\n"
                + "        \"type\": \"NODE\"\n"
                + "      },\n"
                + "      \"index\": 2,\n"
                + "      \"id\": \"FlinkAsiJobResource\",\n"
                + "      \"label\": \"作业资源\"\n"
                + "    },\n"
                + "    {\n"
                + "      \"shape\": \"rect\",\n"
                + "      \"data\": {\n"
                + "        \"defId\": 186490,\n"
                + "        \"outputParams\": [],\n"
                + "        \"tooltip\": {},\n"
                + "        \"inputParams\": [],\n"
                + "        \"id\": \"FlinkAsiJobStatus\",\n"
                + "        \"label\": \"作业状态\",\n"
                + "        \"type\": \"NODE\"\n"
                + "      },\n"
                + "      \"index\": 0,\n"
                + "      \"id\": \"FlinkAsiJobStatus\",\n"
                + "      \"label\": \"作业状态\"\n"
                + "    },\n"
                + "    {\n"
                + "      \"shape\": \"rect\",\n"
                + "      \"data\": {\n"
                + "        \"defId\": 187969,\n"
                + "        \"outputParams\": [],\n"
                + "        \"tooltip\": {},\n"
                + "        \"inputParams\": [],\n"
                + "        \"id\": \"FlinkAsiJobGCTime\",\n"
                + "        \"label\": \"GC时间\",\n"
                + "        \"type\": \"NODE\"\n"
                + "      },\n"
                + "      \"index\": 10,\n"
                + "      \"id\": \"FlinkAsiJobGCTime\",\n"
                + "      \"label\": \"GC时间\"\n"
                + "    },\n"
                + "    {\n"
                + "      \"shape\": \"rect\",\n"
                + "      \"data\": {\n"
                + "        \"defId\": 187970,\n"
                + "        \"outputParams\": [],\n"
                + "        \"tooltip\": {},\n"
                + "        \"inputParams\": [],\n"
                + "        \"id\": \"FlinkAsiJobGCCount\",\n"
                + "        \"label\": \"GC次数\",\n"
                + "        \"type\": \"NODE\"\n"
                + "      },\n"
                + "      \"index\": 11,\n"
                + "      \"id\": \"FlinkAsiJobGCCount\",\n"
                + "      \"label\": \"GC次数\"\n"
                + "    },\n"
                + "    {\n"
                + "      \"shape\": \"rect\",\n"
                + "      \"data\": {\n"
                + "        \"defId\": 188261,\n"
                + "        \"outputParams\": [],\n"
                + "        \"tooltip\": {},\n"
                + "        \"inputParams\": [],\n"
                + "        \"id\": \"FlinkAsiJobEvents\",\n"
                + "        \"label\": \"作业事件\",\n"
                + "        \"type\": \"NODE\"\n"
                + "      },\n"
                + "      \"index\": 1,\n"
                + "      \"id\": \"FlinkAsiJobEvents\",\n"
                + "      \"label\": \"作业事件\"\n"
                + "    }\n"
                + "  ],\n"
                + "  \"edges\": [\n"
                + "    {\n"
                + "      \"shape\": \"QuadraticEdge\",\n"
                + "      \"data\": {\n"
                + "        \"expression\": \"\"\n"
                + "      },\n"
                + "      \"style\": {\n"
                + "        \"endArrow\": true,\n"
                + "        \"stroke\": \"#fdad\",\n"
                + "        \"lineWidth\": 2\n"
                + "      },\n"
                + "      \"source\": \"FlinkAsiJobStatus\",\n"
                + "      \"target\": \"FlinkAsiJobGCCount\"\n"
                + "    },\n"
                + "    {\n"
                + "      \"shape\": \"QuadraticEdge\",\n"
                + "      \"data\": {\n"
                + "        \"expression\": \"\"\n"
                + "      },\n"
                + "      \"style\": {\n"
                + "        \"endArrow\": true,\n"
                + "        \"stroke\": \"#fdad\",\n"
                + "        \"lineWidth\": 2\n"
                + "      },\n"
                + "      \"source\": \"FlinkAsiJobStatus\",\n"
                + "      \"target\": \"FlinkAsiJobGCTime\"\n"
                + "    },\n"
                + "    {\n"
                + "      \"shape\": \"QuadraticEdge\",\n"
                + "      \"data\": {\n"
                + "        \"expression\": \"\"\n"
                + "      },\n"
                + "      \"style\": {\n"
                + "        \"endArrow\": true,\n"
                + "        \"stroke\": \"#fdad\",\n"
                + "        \"lineWidth\": 2\n"
                + "      },\n"
                + "      \"source\": \"FlinkAsiJobStatus\",\n"
                + "      \"target\": \"FlinkAsiJobResource\"\n"
                + "    },\n"
                + "    {\n"
                + "      \"shape\": \"QuadraticEdge\",\n"
                + "      \"data\": {\n"
                + "        \"expression\": \"\"\n"
                + "      },\n"
                + "      \"style\": {\n"
                + "        \"endArrow\": true,\n"
                + "        \"stroke\": \"#fdad\",\n"
                + "        \"lineWidth\": 2\n"
                + "      },\n"
                + "      \"source\": \"FlinkAsiJobStatus\",\n"
                + "      \"target\": \"FlinkAsiJobEvents\"\n"
                + "    }\n"
                + "  ]\n"
                + "}";

        DagDO dagDO = DagDO.builder().content(content).build();
        JSONArray array = new JSONArray();
        array.add("FlinkAsiJobResource");
        array.add("FlinkAsiJobStatus");
        dagDO.updateContent(array, null);
        log.info("{}", JSONObject.toJSONString(dagDO));
        DAG dag = DagUtil.calcDAG(content);
        log.info("{}", dag.chain());
    }

    public void updateContent(JSONArray selectItemArray, JSONObject itemConfigs) throws Exception {
        this.content = fetchNewContent(selectItemArray, itemConfigs);
        boolean isValid = isValid();
        if (!isValid) {
            log.error(">>>dagDO|updateContent|invalid dag|content={}", this.content);
            throw new Exception("invalid dag!content=" + content);
        }
    }

    public boolean isValid() {
        return !DagUtil.calcDAG(content).isCircularity();
    }

    public String fetchNewContent(JSONArray selectItemArray, JSONObject itemConfigs) {
        JSONObject contentJson = JSONObject.parseObject(content);
        if (Objects.isNull(contentJson)) {
            contentJson = new JSONObject();
            contentJson.put("nodes", new JSONArray());
            contentJson.put("edges", new JSONArray());
        }

        if (CollectionUtils.isNotEmpty(selectItemArray)) {
            JSONArray nodeArray = contentJson.getJSONArray("nodes");
            JSONArray nodeTmp = new JSONArray();
            for (int i = 0; i < nodeArray.size(); i++) {
                JSONObject node = nodeArray.getJSONObject(i);
                if (selectItemArray.contains(node.getString("id"))) {
                    nodeTmp.add(node);
                }
            }

            contentJson.put("nodes", nodeTmp);

            JSONArray edgeArray = contentJson.getJSONArray("edges");

            JSONArray edgeTmp = new JSONArray();
            for (int i = 0; i < edgeArray.size(); i++) {
                JSONObject edge = edgeArray.getJSONObject(i);
                if (selectItemArray.contains(edge.getString("source")) && selectItemArray.contains(edge.getString("target"))) {
                    edgeTmp.add(edge);
                }
            }

            contentJson.put("edges", edgeTmp);
        }

        if (MapUtils.isNotEmpty(itemConfigs)) {
            JSONArray nodeArray = contentJson.getJSONArray("nodes");
            for (int i = 0; i < nodeArray.size(); i++) {
                JSONObject node = nodeArray.getJSONObject(i);
                String id = node.getString("id");
                if (itemConfigs.containsKey(id)) {
                    JSONArray inputParams = node.getJSONObject("data").getJSONArray("inputParams");
                    JSONObject itemConfig = itemConfigs.getJSONObject(id);
                    for (int j = 0; j < inputParams.size(); j++) {
                        JSONObject inputParam = inputParams.getJSONObject(j);
                        String inputParamName = inputParam.getString("name");
                        if (itemConfig.containsKey(inputParamName)) {
                            inputParam.put("fromType", ParamFromType.CONSTANT.name());
                            inputParam.put("type", ParamType.STRING.name());
                            inputParam.put("value", itemConfig.getString(inputParamName));
                        }
                    }
                }
            }
        }

        return JSONObject.toJSONString(contentJson);
    }

    public List<DagInputParam> fetchInputParamList() {
        if (StringUtils.isEmpty(inputParams)) {
            return Collections.emptyList();
        }

        List<DagInputParam> dagInputParamList = JSONArray.parseArray(inputParams, DagInputParam.class);
        if (CollectionUtils.isEmpty(dagInputParamList)) {
            return Collections.emptyList();
        }

        return dagInputParamList;
    }

    public void setInputParamList(List<DagInputParam> inputParamList) throws Exception {
        inputParamList = Objects.isNull(inputParamList) ? Collections.emptyList() : inputParamList;
        for (DagInputParam inputParam : inputParamList) {
            inputParam.check();
        }
        this.inputParams = JSONObject.toJSONString(inputParamList, true);
    }
}