package com.alibaba.tesla.dag.repository.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.constant.DagConstant;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Slf4j
public class DagInstDO {
    private Long id;

    private Long gmtCreate;

    private Long gmtModified;

    private Long gmtAccess;

    private String appId;

    private Long dagId;

    private String status;

    private String lockId;

    private String creator;

    private Boolean isSub;

    private String tag;

    private String standaloneIp;

    private String channel;

    private String env;

    private Long fatherDagInstNodeId;

    private Integer version;

    private String tcDagDetail;

    private String statusDetail;

    private String globalParams;

    private String globalObject;

    private String globalVariable;

    private String globalResult;

    private String evaluationCreateRet;

    private String drgDetail;

    public DagDO fetchDagDO() {
        DagDO dagDO = JSONObject.parseObject(tcDagDetail, DagDO.class);
        if (Objects.isNull(dagDO)) {
            dagDO = new DagDO();
        }

        return dagDO;
    }

    public JSONObject fetchGlobalVariableJson() {
        return StringUtils.isEmpty(globalVariable) ? new JSONObject() : JSONObject.parseObject(globalVariable);
    }

    public JSONObject fetchGlobalResultJson() {
        return StringUtils.isEmpty(globalResult) ? new JSONObject() : JSONObject.parseObject(globalResult);
    }

    public JSONObject fetchGlobalParamsJson() {
        return StringUtils.isEmpty(globalParams) ? new JSONObject() : JSONObject.parseObject(globalParams);
    }

    public DagInstStatus fetchStatus() {
        return DagInstStatus.valueOf(status);
    }

    public String fetchChannel() {
        if (StringUtils.isEmpty(channel)) {
            return "NotDefined";
        }
        return channel;
    }

    /**
     * 子DAG存在关联的节点
     *
     * @param dagInstNodeDO
     */
    public void setRelationNode(DagInstNodeDO dagInstNodeDO) {
        JSONObject globalVariableJson = fetchGlobalVariableJson();
        globalVariableJson.put("__NODE__ID__", dagInstNodeDO.getNodeId());
        globalVariableJson.put("__INST__ID__", dagInstNodeDO.getDagInstId());
        globalVariable = JSONObject.toJSONString(globalVariableJson);
    }

    public JSONObject fetchExpressionParamsJson() {
        JSONObject jsonObject = fetchGlobalResultJson();
        jsonObject.put(DagConstant.GLOBAL_VARIABLE, fetchGlobalVariableJson());
        jsonObject.put(DagConstant.OUTPUT_GLOBAL_PARAMS_KEY, fetchGlobalParamsJson());
        return jsonObject;
    }

    public String fetchRelationNodeId() {
        return fetchGlobalVariableJson().getString("__NODE__ID__");
    }

    public Long fetchRelationInstId() {
        return fetchGlobalVariableJson().getLong("__INST__ID__");
    }
}