package com.alibaba.tesla.dag.repository.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.schedule.status.DagInstEdgeStatus;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DagInstEdgeDO {
    private Long id;

    private Long gmtCreate;

    private Long gmtModified;

    private Long dagInstId;

    private String source;

    private String target;

    private String label;

    private String shape;

    private Integer isPass;

    private String status;

    private String style;

    private String data;

    private String exception;

    public String fetchKey() {
        return source + "-" + target;
    }

    public JSONObject fetchDataJson() {
        return StringUtils.isEmpty(data) ? new JSONObject() : JSONObject.parseObject(data);
    }

    public String fetchExpressionString() {
        return fetchDataJson().getString("expression");
    }

    public DagInstEdgeStatus fetchEdgeStatus() {
        return DagInstEdgeStatus.valueOf(status);
    }
}