package com.alibaba.tesla.dag.repository.domain;

import java.io.Serializable;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Slf4j
public class DagInstNodeDO{
    private Long id;

    private Long gmtCreate;

    private Long gmtModified;

    private Long gmtStart;

    private Long dagInstId;

    private String nodeId;

    private String status;

    private String taskId;

    private String stopTaskId;

    private String lockId;

    private Long subDagInstId;

    private Long retryTimes;

    private String drgSerial;

    private String statusDetail;

    private String tcDagOrNodeDetail;

    private String tcDagContentNodeSpec;

    private String globalParams;

    private String globalObject;

    private String globalResult;

    private JSONObject nodeJson;

    public JSONObject fetchNodeJson() {
        if (MapUtils.isEmpty(nodeJson)) {
            nodeJson = JSONObject.parseObject(tcDagContentNodeSpec);
        }
        return nodeJson;
    }

    public DagInstNodeType fetchNodeType() {
        return DagInstNodeType.valueOf(fetchNodeJson().getJSONObject("data").getString("type"));
    }

    public DagInstNodeStatus fetchNodeStatus() {
        return DagInstNodeStatus.valueOf(status);
    }

    public Long fetchDefId() {
        return fetchNodeJson().getJSONObject("data").getLongValue("defId");
    }

    public DagNodeDO fetchDagNode() {
        return JSONObject.parseObject(tcDagOrNodeDetail, DagNodeDO.class);
    }

    public List<DagNodeInputParam> fetchInputParamList() {
        List<DagNodeInputParam> dagNodeInputParamsFromDag = DagNodeInputParam.toList(
            fetchNodeJson().getJSONObject("data").getJSONArray("inputParams")
        );
        List<DagNodeInputParam> dagNodeInputParamsFromNode = fetchDagNode().fetchInputParamList();

        for (DagNodeInputParam dagNodeInputParamFromDag : dagNodeInputParamsFromDag) {
            for (DagNodeInputParam dagNodeInputParamFromNode : dagNodeInputParamsFromNode) {
                if (dagNodeInputParamFromDag.getName().equals(dagNodeInputParamFromNode.getName())) {
                    dagNodeInputParamFromDag.setType(dagNodeInputParamFromNode.getType());
                }
            }
        }

        return dagNodeInputParamsFromDag;
    }

    public String toSimpleString() {
        final StringBuffer sb = new StringBuffer("DagInstNodeDO{");
        sb.append("id=").append(id);
        sb.append(", dagInstId=").append(dagInstId);
        sb.append(", nodeId='").append(nodeId).append('\'');
        sb.append(", taskId='").append(taskId).append('\'');
        sb.append('}');
        return sb.toString();
    }
}