package com.alibaba.tesla.dag.repository.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.tesla.dag.constant.DagConstant;
import com.alibaba.tesla.dag.schedule.task.TaskStatus;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DagInstNodeStdDO {
    private Long id;

    private Long gmtCreate;

    private Long gmtModified;

    private Long gmtAccess;

    private String status;

    private String ip;

    private String standaloneIp;

    private Boolean isStop;

    private Long stopId;

    private String lockId;

    private Long dagInstNodeId;

    private Long dagInstId;

    private String channel;

    private String stdout;

    private String stderr;

    private String globalParams;

    private String initGlobalParams;

    private String comment;

    public TaskStatus fetchStatus() {
        return TaskStatus.valueOf(status);
    }

    public Object fetchGlobalParams() {
        if (!isDelete(globalParams)) {
            return JSONObject.parseObject(globalParams);
        }
        return globalParams;
    }

    public JSONObject fetchStdout() {
        return JSONObject.parseObject(stdout, Feature.OrderedField);
    }

    private static boolean isDelete(String global) {
        return StringUtils.equals(DagConstant.FAAS_DELETE_OPERATION, global);
    }
}