package com.alibaba.tesla.dag.repository.domain;

import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailApi;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailFaas;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailInterface;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailLocal;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeDetailTask;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeType;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DagNodeDO {
    private Long id;

    private Long gmtCreate;

    private Long gmtModified;

    private String appId;

    private String name;

    private String alias;

    private Boolean isShare;

    private String type;

    private Boolean isShow;

    private String formatType;

    private String creator;

    private String modifier;

    private Boolean isSupportChatops;

    private String lastUpdateBy;

    private Long runTimeout;

    private Long maxRetryTimes;

    private String description;

    private String inputParams;

    private String outputParams;

    private String detail;

    private String formatDetail;

    private String chatopsDetail;

    private String retryExpression;

    public DagNodeType fetchNodeType() {
        return DagNodeType.valueOf(type);
    }

    public List<DagNodeInputParam> fetchInputParamList() {
        return DagNodeInputParam.toList(JSONArray.parseArray(inputParams));
    }

    public DagNodeDetailInterface fetchDetailInterface() {
        switch (fetchNodeType()) {
            case LOCAL:
                return JSONObject.parseObject(detail, DagNodeDetailLocal.class);
            case TASK:
                return JSONObject.parseObject(detail, DagNodeDetailTask.class);
            case API:
                return JSONObject.parseObject(detail, DagNodeDetailApi.class);
            case FAAS:
                return JSONObject.parseObject(detail, DagNodeDetailFaas.class);
            default:
                return null;
        }
    }

    public static void main(String[] args){
        String s = "{\"alias\":\"HOLO集群ASI-EVENT检查\",\"appId\":\"holo\",\"chatopsDetail\":\"{}\","
            + "\"creator\":\"61489\",\"description\":\"HOLO集群ASI-EVENT检查\","
            + "\"detail\":\"{\\\"itemName\\\":\\\"holo:JOB_BIZ_KEY_9280d01a835e4be1969e36de2c877ece\\\","
            + "\\\"appId\\\":\\\"holo\\\",\\\"bizKey\\\":\\\"JOB_BIZ_KEY_9280d01a835e4be1969e36de2c877ece\\\"}\","
            + "\"detailInterface\":{\"appId\":\"holo\",\"bizKey\":\"JOB_BIZ_KEY_9280d01a835e4be1969e36de2c877ece\"},"
            + "\"formatDetail\":\"{}\",\"formatType\":\"TABLE\",\"gmtCreate\":1619334749,\"gmtModified\":1619334749,"
            + "\"id\":840103,\"inputParamList\":[{\"alias\":\"cluster\",\"fromType\":\"CONSTANT\","
            + "\"isOverWrite\":true,\"name\":\"cluster\",\"type\":\"STRING\",\"value\":\"cluster\"}],"
            + "\"inputParams\":\"[{\\\"name\\\":\\\"cluster\\\",\\\"alias\\\":\\\"cluster\\\","
            + "\\\"value\\\":\\\"cluster\\\",\\\"isOverWrite\\\":true,\\\"type\\\":\\\"STRING\\\"}]\","
            + "\"isShare\":false,\"isShow\":true,\"isSupportChatops\":true,\"lastUpdateBy\":\"WEB\","
            + "\"modifier\":\"61489\",\"name\":\"holo_cluster_check_asi_event\",\"nodeType\":\"TASK\","
            + "\"outputParams\":\"null\",\"type\":\"TASK\"}";

        DagNodeDO dagNodeDO = JSONObject.parseObject(s, DagNodeDO.class);
        System.out.println(dagNodeDO);
    }
}