package com.alibaba.tesla.dag.schedule;

import com.alibaba.tesla.dag.common.Tools;
import com.alibaba.tesla.dag.model.domain.TcDagServiceNode;
import com.alibaba.tesla.dag.model.repository.TcDagServiceNodeRepository;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.concurrent.BasicThreadFactory.Builder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author jinghua.yjh
 */
@Slf4j
@Service
@DependsOn(value = "beanUtil")
public class DagSchedule {

    @Autowired
    TcDagServiceNodeRepository dagServiceNodeRepository;

    private ScheduledThreadPoolExecutor initExecutor = new ScheduledThreadPoolExecutor(
            2, new Builder().namingPattern("%d").daemon(true).build());

    @PostConstruct
    private void init() {
        initExecutor.scheduleAtFixedRate(this::upsertNode, 0, 10, TimeUnit.SECONDS);
    }

    private void upsertNode() {
        try {
            String ip = Tools.localIp;
            TcDagServiceNode dagServiceNode = dagServiceNodeRepository.findFirstByIp(ip);
            if (dagServiceNode == null) {
                dagServiceNode = TcDagServiceNode.builder().ip(ip).enable(1).build();
            }
            dagServiceNode.saveWithTime();
            dagServiceNode.flush();
        } catch (Exception e) {
            log.error("upsertNode", e);
        }
    }
}
