package com.alibaba.tesla.dag.schedule;

import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.util.MonitorUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Configuration
@EnableScheduling
@Slf4j(topic = "monitor")
public class MonitorScheduleTask {
    @Autowired
    private ThreadPoolTaskExecutor instAsyncTaskExecutor;

    @Autowired
    private ThreadPoolTaskExecutor nodeAsyncTaskExecutor;

    @Autowired
    private ApplicationProperties applicationProperties;

    @Scheduled(fixedRate = 2000)
    public void configureTasks() {
        log.info(">>>monitorJob|cost|inst={}, nodeStart={}, job={}, task={}, stdout={}, status={}",
                MonitorUtil.instMonitor.toString(), MonitorUtil.nodeStartMonitor.toString(),
                MonitorUtil.jobMonitor.toString(), MonitorUtil.taskMonitor.toString(),
                MonitorUtil.stdOutMonitor.toString(), MonitorUtil.statusMonitor.toString());

        if (applicationProperties.isJarUseMode()) {
            log.info(">>>monitorJob|threadPool|inst={}, node={}, job={}",
                    instAsyncTaskExecutor.getActiveCount(), nodeAsyncTaskExecutor.getActiveCount());
        }
    }
}
