package com.alibaba.tesla.dag.schedule.evaluation;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.Requests;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author jinghua.yjh
 */
@Slf4j
@Service
public class EvaluationService {

    @Value("${evaluation.endpoint:}")
    public String evaluationEndpoint;

    public String create(TcDagInst dagInst) {
        if (StringUtils.isEmpty(evaluationEndpoint)) {
            return JSONObject.toJSONString(ImmutableMap.of(
                "id", "-2",
                "error_info", "evaluationEndpoint is null"
            ));
        }
        try {
            JSONObject retJson = Requests.post(evaluationEndpoint + "/evaluation/create",
                JSONObject.toJSONString(ImmutableMap.of(
                    "targetAppId", dagInst.getAppId(),
                    "targetType", "通用诊断-" + dagInst.dag().getName(),
                    "targetId", Long.toString(dagInst.getId()),
                    "modifier", dagInst.getCreator(),
                    "tags", dagInst.channel()
                )), JSONObject.class);
            return JSONObject.toJSONString(retJson.getJSONObject("data"));
        } catch (Exception e) {
            log.error("create evaluation error", e);
            return JSONObject.toJSONString(ImmutableMap.of(
                "id", "-1",
                "error_info", Throwables.getStackTraceAsString(e)
            ));
        }
    }

    public String create(DagInstDO dagInstDO) {
        if (StringUtils.isEmpty(evaluationEndpoint)) {
            return JSONObject.toJSONString(ImmutableMap.of(
                "id", "-2",
                "error_info", "evaluationEndpoint is null"
            ));
        }
        try {
            JSONObject retJson = Requests.post(evaluationEndpoint + "/evaluation/create",
                JSONObject.toJSONString(ImmutableMap.of(
                    "targetAppId", dagInstDO.getAppId(),
                    "targetType", "通用诊断-" + dagInstDO.fetchDagDO().getName(),
                    "targetId", Long.toString(dagInstDO.getId()),
                    "modifier", dagInstDO.getCreator(),
                    "tags", dagInstDO.fetchChannel()
                )), JSONObject.class);
            return JSONObject.toJSONString(retJson.getJSONObject("data"));
        } catch (Exception e) {
            log.error("create evaluation error", e);
            return JSONObject.toJSONString(ImmutableMap.of(
                "id", "-1",
                "error_info", Throwables.getStackTraceAsString(e)
            ));
        }
    }

}
