package com.alibaba.tesla.dag.schedule.event;

import com.alibaba.tesla.dag.schedule.status.DagInstStatus;

import org.springframework.context.ApplicationEvent;

public class DagInstStatusEvent extends ApplicationEvent {

    public final Long dagInstId;

    public final DagInstStatus from;

    public final DagInstStatus to;

    public DagInstStatusEvent(Object source, Long dagInstId, DagInstStatus from, DagInstStatus to) {
        super(source);
        this.dagInstId = dagInstId;
        this.from = from;
        this.to = to;
    }


    @Override
    public String toString() {
        return "DagInstStatusEvent{" +
                "dagInstId=" + dagInstId +
                ", from=" + from +
                ", to=" + to +
                '}';
    }
}
