package com.alibaba.tesla.dag.schedule.status;

/**
 * @author jinghua.yjh
 */

public enum DagInstNodeStatus {

    // 初始化
    INIT,

    // 执行中
    RUNNING,

    // 执行成功
    SUCCESS,

    //合并状态
    MERGE,

    // 调度错误
    EXCEPTION,

    // 跳过, 只会由于edge判断不过, 多入的单个跳过不影响执行,
    SKIP,

    // 等待停止
    WAIT_STOP,

    // 停止中
    STOPPING,

    // 停止完成
    STOPPED,

    // 停止跳过, 由于上层停止的跳过, 影响后续所有执行
    SKIP_CAUSE_BY_STOPPED,

    // 失败跳过, 由于上层异常的跳过, 影响后续所有执行
    SKIP_CAUSE_BY_EXCEPTION;

    public boolean isRunningOrInit() {
        switch (this) {
            case INIT:
            case RUNNING:
                return true;
            default:
                return false;
        }
    }

    public boolean isNotSkip() {
        return this != DagInstNodeStatus.SKIP;
    }

    public boolean isSkip() {
        return this == DagInstNodeStatus.SKIP;
    }

    public boolean isSkipOrSuccess() {
        return this == DagInstNodeStatus.SKIP || this == DagInstNodeStatus.SUCCESS;
    }

    public boolean isNotSkipAndNotSuccess() {
        return this != DagInstNodeStatus.SKIP && this != DagInstNodeStatus.SUCCESS;
    }

    public boolean isSuccess() {
        return this == DagInstNodeStatus.SUCCESS;
    }

    public boolean isException() {
        switch (this) {
            case EXCEPTION:
            case SKIP_CAUSE_BY_EXCEPTION:
                return true;
            default:
                return false;
        }
    }

    public boolean isStopped() {
        switch (this) {
            case STOPPED:
            case SKIP_CAUSE_BY_STOPPED:
                return true;
            default:
                return false;
        }
    }

    public boolean isEnd() {
        switch (this) {
            case INIT:
            case RUNNING:
            case STOPPING:
            case WAIT_STOP:
                return false;
            case EXCEPTION:
            case STOPPED:
            case SUCCESS:
            case SKIP_CAUSE_BY_EXCEPTION:
            case SKIP_CAUSE_BY_STOPPED:
            case SKIP:
            default:
                return true;
        }
    }

}
