package com.alibaba.tesla.dag.schedule.status;

/**
 * @author jinghua.yjh
 */

public enum DagInstStatus {

    // 初始化
    INIT,

    // 前置执行中
    PRE_RUNNING,

    // 执行中
    RUNNING,

    // 后置执行中
    POST_RUNNING,

    // 等待停止
    WAIT_STOP,

    // 停止中
    STOPPING,

    // 停止完成
    STOPPED,

    // 执行成功
    SUCCESS,

    // 调度错误
    EXCEPTION;

    public boolean isEnd() {
        switch (this) {
            case SUCCESS:
            case STOPPED:
            case EXCEPTION:
                return true;
            default:
                return false;
        }
    }
}
