package com.alibaba.tesla.dag.selfcheck;

import com.alibaba.tesla.dag.local.AbstractLocalNodeBase;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeRunRet;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;

/**
 * @author yaoxing.gyx@alibaba-inc.com
 */
@Slf4j
public class SelfCheckNode extends AbstractLocalNodeBase {

    @Override
    public DagInstNodeRunRet run() throws Exception {
        assert "pre".equals(globalParams.getString("pre"));
        globalParams.put(dagInstId + "_" + nodeId + "_" + fatherNodeId, ImmutableMap.of(
                "key", "value"
        ));
        return DagInstNodeRunRet.builder().build();
    }

}