package com.alibaba.tesla.dag.selfcheck;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.api.DagApiServiceImpl;
import com.alibaba.tesla.dag.api.DagCreateEdge;
import com.alibaba.tesla.dag.api.DagCreateNode;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeType;
import com.alibaba.tesla.dag.provider.DagInstProvider;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

/**
 * @author qiuqiang.qq@alibaba-inc.com
 */
@Slf4j
@Service
public class SelfCheckService {

    @Autowired
    private DagApiServiceImpl dagApiService;

    @Autowired
    private DagInstProvider dagInstProvider;

    public Long dag() throws Exception {
        dagApiService.create(
                "selfcheck_dag_sub_scene",
                Arrays.asList(
                        DagCreateNode.builder().name("SelfCheckNode").nodeId("node1").build(),
                        DagCreateNode.builder().name("SelfCheckNode").nodeId("node2").build()
                ),
                Collections.singletonList(
                        DagCreateEdge.builder().sourceNodeId("node1").targetNodeId("node2").expression("1==1").build()
                )
        );

        dagApiService.create(
                "selfcheck_dag_scene",
                Arrays.asList(
                        DagCreateNode.builder()
                                .name("selfcheck_dag_sub_scene").nodeId("node1").type(DagInstNodeType.DAG).build(),
                        DagCreateNode.builder()
                                .name("selfcheck_dag_sub_scene").nodeId("node2").type(DagInstNodeType.DAG).build()
                ),
                Collections.singletonList(
                        DagCreateEdge.builder().sourceNodeId("node1").targetNodeId("node2").expression("1==1").build()
                )
        );

        JSONObject commonParams = new JSONObject();
        commonParams.put("nameEn", "selfcheck_dag_scene");
        Long dagInstId = dagInstProvider.submit("tesla", "", "", "", commonParams, false);

        return dagInstId;
    }

    public Long selfcheck() throws Exception {
        DagCreateNode preNode = DagCreateNode.builder()
                .params(new HashMap<>(0))
                .name("SelfCheckPreNode")
                .nodeId("prenode")
                .type(DagInstNodeType.NODE)
                .build();

        DagCreateNode node1 = DagCreateNode.builder()
                .params(new HashMap<>(0))
                .name("SelfCheckNode")
                .nodeId("selfcheck_node_1")
                .type(DagInstNodeType.NODE)
                .build();
        DagCreateNode node2 = DagCreateNode.builder()
                .params(new HashMap<>(0))
                .name("SelfCheckNode")
                .nodeId("selfcheck_node_2")
                .type(DagInstNodeType.NODE)
                .build();
        DagCreateEdge edge = DagCreateEdge.builder()
                .sourceNodeId("selfcheck_node_1")
                .targetNodeId("selfcheck_node_2")
                .expression("1==1")
                .build();
        dagApiService.create("selfcheck_sub_scene", Arrays.asList(node1, node2),
                Collections.singletonList(edge));

        DagCreateNode nodehigh1 = DagCreateNode.builder()
                .params(new HashMap<>(0))
                .name("selfcheck_sub_scene")
                .nodeId("selfcheck_scene_node_1")
                .type(DagInstNodeType.DAG)
                .build();
        DagCreateNode nodehigh2 = DagCreateNode.builder()
                .params(new HashMap<>(0))
                .name("selfcheck_sub_scene")
                .nodeId("selfcheck_scene_node_2")
                .type(DagInstNodeType.DAG)
                .build();
        DagCreateEdge edge1 = DagCreateEdge.builder()
                .sourceNodeId("selfcheck_scene_node_1")
                .targetNodeId("selfcheck_scene_node_2")
                .expression("1==1")
                .build();
        dagApiService.create("selfcheck_scene", preNode, null, Arrays.asList(nodehigh1, nodehigh2),
                Collections.singletonList(edge1));

        JSONObject commonParams = new JSONObject();
        commonParams.put("nameEn", "selfcheck_scene");
        Long dagInstId = dagInstProvider.submit("tesla", "", "", "", commonParams, false);

        return dagInstId;

    }

}