package com.alibaba.tesla.dag.services;

import com.alibaba.tesla.dag.notify.DagInstDispatch;
import com.alibaba.tesla.dag.notify.DagInstNodeTask;
import com.alibaba.tesla.dag.notify.NodeTaskType;
import com.alibaba.tesla.dag.util.MonitorUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Slf4j
@Lazy
public class AsyncService {
    @Autowired
    private DagInstNewService dagInstNewService;

    @Autowired
    private DagInstNodeNewService dagInstNodeNewService;

    @Autowired
    private LockService lockService;

    @Async("instAsyncTaskExecutor")
    public void doDagInstDispatch(DagInstDispatch dagInstDispatch) {
        try {
            log.info(">>>[Inst Receive]|dagInstEvent={}", dagInstDispatch);
            dagInstNewService.doDagInstDispatch(dagInstDispatch);
        } catch (Exception e) {
            log.error(">>>asyncService|doDagInstEvent|err={}", e.getMessage(), e);
        }
    }

    @Async("nodeAsyncTaskExecutor")
    public void doDagInstNodeTask(DagInstNodeTask dagInstNodeTask) {
        try {
            log.info(">>>[Node Receive]|dagInstNodeTask={}", dagInstNodeTask);
            if (dagInstNodeTask.getNodeTaskType() == NodeTaskType.START) {
                dagInstNodeNewService.startDagInstNode(dagInstNodeTask);
            } else if (dagInstNodeTask.getNodeTaskType() == NodeTaskType.INSPECT) {
                dagInstNodeNewService.inspectDagInstNode(dagInstNodeTask);
            }

        } catch (Exception e) {
            log.error(">>>asyncService|doDagInstNodeTask|err={}", e.getMessage(), e);
        }
        finally {
            lockService.unLock(dagInstNodeTask.fetchKey());
        }
    }
}
