package com.alibaba.tesla.dag.services;

import com.alibaba.tesla.dag.model.repository.TcDagInstEdgeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeStdRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author QianMo
 * @date 2021/04/01.
 */
@Slf4j
@Service
public class DagInstClearService {
    @Autowired
    private TcDagInstRepository dagInstRepository;

    @Autowired
    private TcDagInstNodeRepository dagInstNodeRepository;

    @Autowired
    private TcDagInstEdgeRepository tcDagInstEdgeRepository;

    @Autowired
    private TcDagInstNodeStdRepository tcDagInstNodeStdRepository;

    public void clearDataBefore(Date date) {
        long seconds = date.getTime() / 1000;
        long beginTimeMillis = System.currentTimeMillis();
        try {
            int delete4DagInst = dagInstRepository.deleteByGmtCreate(seconds);
            int delete4DagInstNode = dagInstNodeRepository.deleteByGmtCreate(seconds);
            int delete4DagInstEdge = tcDagInstEdgeRepository.deleteByGmtCreate(seconds);
            int delete4DagInstNodeStd = tcDagInstNodeStdRepository.deleteByGmtCreate(seconds);

            log.info(
                    ">>>dagInstClearService|clearDataBefore|exit|costTime={}, delete4DagInst={}, delete4DagInstNode={}, "
                            + "delete4DagInstEdge={}, delete4DagInstNodeStd={}",
                    System.currentTimeMillis() - beginTimeMillis, delete4DagInst, delete4DagInstNode, delete4DagInstEdge, delete4DagInstNodeStd);
        } catch (Exception e) {
            log.error(">>>dagInstClearService|clearDataBefore|err={}", e.getMessage(), e);
        }

    }
}
