package com.alibaba.tesla.dag.services;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.TcDag;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author jinghua.yjh
 */
@Service
public class DagService {

    @Autowired
    TcDagRepository dagRepository;

    @Autowired
    TcDagNodeRepository dagNodeRepository;

    public Long copyDag(Long dagId, String dstAppId, String nameHeader) throws Exception {
        if (StringUtils.isEmpty(nameHeader)) {
            nameHeader = "__COPY" + System.currentTimeMillis() + "__";
        }
        TcDag dag = new TcDag();
        TcDag sourceDag = dagRepository.findFirstById(dagId);
        if (sourceDag == null) {
            throw new Exception("sourceDag can not be null");
        }
        BeanUtils.copyProperties(sourceDag, dag);
        dag.setId(null);
        dag.setAppId(dstAppId);
        dag.setName(nameHeader + sourceDag.getName());
        dag.setLastUpdateBy("");

        List<JSONObject> nodeList = dag.nodes();
        for (JSONObject node : nodeList) {
            String nodeType = node.getJSONObject("data").getString("type");
            Long nodeDefId;
            Long dagNodeId = node.getJSONObject("data").getLongValue("defId");
            if ("DAG".equals(nodeType)) {
                nodeDefId = copyDag(dagNodeId, dstAppId, nameHeader);
            } else {
                TcDagNode dagNode = new TcDagNode();
                TcDagNode sourceDagNode = dagNodeRepository.findFirstById(dagNodeId);
                if (sourceDagNode == null) {
                    throw new Exception("sourceDagNode is null: " + JSONObject.toJSONString(node));
                }
                String dagNodeName = nameHeader + sourceDagNode.getName();
                TcDagNode dstDagNode = dagNodeRepository.findFirstByAppIdAndName(dstAppId, dagNodeName);
                if (dstDagNode != null) {
                    nodeDefId = dstDagNode.getId();
                } else {
                    BeanUtils.copyProperties(sourceDagNode, dagNode);
                    dagNode.setId(null);
                    dagNode.setAppId(dstAppId);
                    dagNode.setName(dagNodeName);
                    dagNode.setGmtCreate(System.currentTimeMillis() / 1000);
                    dagNode.setLastUpdateBy("");
                    dagNode.saveWithTime();
                    dagNode.flush();
                    nodeDefId = dagNode.getId();
                }
            }
            node.getJSONObject("data").put("defId", nodeDefId);
        }
        JSONObject contentJson = dag.contentJson();
        contentJson.put("nodes", nodeList);
        dag.setContent(JSONObject.toJSONString(contentJson));
        dag.setGmtCreate(System.currentTimeMillis() / 1000);
        TcDag dstDag = dagRepository.findFirstByAppIdAndName(dstAppId, dag.getName());
        if (dstDag != null) {
            return dstDag.getId();
        }
        dag.saveWithTime();
        dag.flush();
        return dag.getId();
    }

    public void deleteDagById(Long id){
        dagRepository.deleteById(id);
    }

}
