package com.alibaba.tesla.dag.services;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.constant.DagConstant;
import com.alibaba.tesla.dag.local.LocalTaskDO;
import com.alibaba.tesla.dag.local.LocalTaskProducer;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeType;
import com.alibaba.tesla.dag.repository.dao.DagInstNodeStdDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeStdDO;
import com.alibaba.tesla.dag.schedule.task.TaskStatus;
import com.alibaba.tesla.dag.util.IPUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author jinghua.yjh
 */
@Slf4j
@Service
public class LocalActionNewService extends AbstractActionNewService {

    @Autowired
    private DagInstNodeStdDAO dagInstNodeStdDAO;

    @Autowired
    private LocalTaskProducer localTaskProducer;


    @Override
    public Long start(DagInstDO dagInst, DagInstNodeDO dagInstNode) throws Exception {
        DagInstNodeStdDO dagInstNodeStd = DagInstNodeStdDO.builder()
                .status(TaskStatus.INIT.name())
                .ip(dagInst.getStandaloneIp())
                .standaloneIp(dagInst.getStandaloneIp())
                .lockId(IPUtil.getLockId())
                .dagInstId(dagInst.getId())
                .dagInstNodeId(dagInstNode.getId())
                .build();

        dagInstNodeStdDAO.insert(dagInstNodeStd);

        LocalTaskDO localTaskDO = LocalTaskDO.builder().dagInstId(dagInst.getId()).nodeId(dagInstNode.getNodeId())
                .taskId(dagInstNodeStd.getId()).build();
        localTaskProducer.sendLocalTask(localTaskDO);
        return dagInstNodeStd.getId();
    }

    @Override
    public DagNodeType registerNodeType() {
        return DagNodeType.LOCAL;
    }

    @Override
    public TaskStatus status(Long taskId) throws Exception {
        return dagInstNodeStdDAO.getDagInstNodeStdById(taskId).fetchStatus();
    }

    @Override
    public JSONObject stdout(Long taskId) throws Exception {
        DagInstNodeStdDO dagInstNodeStd = dagInstNodeStdDAO.getDagInstNodeStdById(taskId);
        JSONObject retJson = new JSONObject();
        retJson.put(DagConstant.OUTPUT_GLOBAL_PARAMS_KEY, dagInstNodeStd.fetchGlobalParams());
        retJson.put(OUTPUT_DATA_KEY, dagInstNodeStd.fetchStdout());
        return retJson;
    }

    @Override
    public String stderr(Long taskId) throws Exception {
        return dagInstNodeStdDAO.getDagInstNodeStdById(taskId).getStderr();
    }

    @Override
    public Long stop(Long taskId) throws Exception {
        DagInstNodeStdDO updateInstNodeStd = DagInstNodeStdDO.builder().id(taskId).isStop(Boolean.TRUE).stopId(taskId).build();
        dagInstNodeStdDAO.update(updateInstNodeStd);
        return updateInstNodeStd.getId();
    }

}
