package com.alibaba.tesla.dag.services;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * @author QianMo
 * @date 2021/04/29.
 */
@Slf4j
@Service
public class LockService {
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public boolean tryLock(String key) {
        try {
            return stringRedisTemplate.opsForValue().setIfAbsent(key, "true", 10, TimeUnit.SECONDS);
        } catch (Exception e) {
            log.error(">>>lockService|tryLock|err={}", e.getMessage(), e);
        }

        return false;
    }

    public void unLock(String key) {
        try {
            stringRedisTemplate.delete(key);
        } catch (Exception e) {
            log.error(">>>lockService|unLock|err={}", e.getMessage(), e);
        }
    }
}
