package com.alibaba.tesla.dag.services;

import java.util.List;

import com.alibaba.tesla.dag.repository.dao.DagInstDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.util.DateUtil;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author QianMo
 * @date 2021/04/29.
 */
@Slf4j
@Service
public class TaskFlowDispatchService {
    @Autowired
    private DagInstDAO dagInstDAO;

    @Autowired
    private DagInstNewService dagInstNewService;

    public int dispatch(int minutesAgo, int secondsAgo) {
        Long end = DateUtil.currentSeconds() - secondsAgo;
        Long begin = end - minutesAgo * DateUtil.MINUTE;

        List<DagInstDO> timeOutList = dagInstDAO.listTimeOut(begin, end);

        if (CollectionUtils.isNotEmpty(timeOutList)) {
            for (DagInstDO dagInstDO : timeOutList) {
                try {
                    dagInstNewService.doDagInstDispatch(dagInstDO);
                    dagInstNewService.inspectDagInstNode(dagInstDO);
                }
                catch (Exception e){
                    log.error(">>>taskFlowDispatchService|dispatch|ERROR|dagInstDO={}, err={}", dagInstDO,
                            e.getMessage(), e);
                }
            }
        }

        return CollectionUtils.size(timeOutList);
    }
}
