package com.alibaba.tesla.dag.util;

import com.alibaba.tesla.dag.common.Tools;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author QianMo
 * @date 2021/04/21.
 */
public class IPUtil {
    public static boolean isIp(String addr) {

        if (StringUtils.isEmpty(addr) || addr.length() < 7 || addr.length() > 15) {
            return false;
        }

        /**
         * 判断IP格式和范围

         */
        String regex = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(regex);
        Matcher mat = pat.matcher(addr);
        boolean ipAddress = mat.find();
        return ipAddress;
    }

    public static List<String> toIpList(String addrsString) {
        if (StringUtils.isEmpty(addrsString)) {
            return Collections.emptyList();
        }

        String[] addrs = StringUtils.split(addrsString, ",");
        List<String> addrList = new ArrayList<>(addrs.length);
        for (String addr : addrs) {
            if (!isIp(addr)) {
                return Collections.emptyList();
            }

            addrList.add(addr);
        }

        return addrList;
    }

    public static String getLockId() {
        return "V2_" + Tools.localIp + "_" + UUID.randomUUID().toString().replace("-", "");
    }
}
