package com.alibaba.tesla.dag.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Monitor {
    private AtomicInteger totalCount = new AtomicInteger(0);

    private AtomicLong totalCost = new AtomicLong(0);

    public void addCost(long cost) {
        totalCost.addAndGet(cost);
        totalCount.incrementAndGet();
    }

    public String toString() {
        long cost = totalCost.getAndSet(0);
        int count = totalCount.getAndSet(0);
        return "[" + count + ":" + (count == 0 ? 0 : cost * 1.0 / count) + "]";
    }
}
