/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApplicationProperties {
    private static final Logger log = LoggerFactory.getLogger(ApplicationProperties.class);
    @Value(value="${tesla.gateway.url:}")
    public String teslaGatewayUrl;
    @Value(value="${tesla.check.url:}")
    public String teslaCheckUrl;
    @Value(value="${tesla.task.instance.format:}")
    public String teslaTaskInstance;
    @Value(value="${tesla.dag.localnode.reflection.prefix:com.alibaba.tesla}")
    public String teslaDagLocalnodeReflectionPrefix;
    @Value(value="${tesla.dag.localnode.jar.path:/home/admin/tesla-check/local/jar/}")
    public String teslaDagLocalnodeJarPath;
    @Value(value="${tesla.dag.localnode.runMaxSize:20}")
    public int teslaDagLocalnodeRunMaxSize;
    @Value(value="${dag.hot.load.jar.interval.second:2}")
    public Long dagHotLoadJarIntervalSecond;
    @Value(value="${dag.hot.load.jar.oss.endpoint:}")
    public String dagHotLoadJarOssEndpoint;
    @Value(value="${dag.hot.load.jar.oss.accessKeyId:}")
    public String dagHotLoadJarOssAccessKeyId;
    @Value(value="${dag.hot.load.jar.oss.accessKeySecret:}")
    public String dagHotLoadJarOssAccessKeySecret;
    @Value(value="${dag.hot.load.jar.oss.bucket.name:}")
    public String dagHotLoadJarOssBucketName;
    @Value(value="${dag.hot.load.jar.minio.endpoint:}")
    public String dagHotLoadJarMinioEndpoint;
    @Value(value="${dag.hot.load.jar.minio.accessKeyId:}")
    public String dagHotLoadJarMinioAccessKeyId;
    @Value(value="${dag.hot.load.jar.minio.accessKeySecret:}")
    public String dagHotLoadJarMinioAccessKeySecret;
    @Value(value="${dag.hot.load.jar.minio.bucket.name:}")
    public String dagHotLoadJarMinioBucketName;
    @Value(value="${dag.usage.mode:}")
    private String dagUseMode;
    @Value(value="${tesla.gateway.endpoint:}")
    private String teslaGatewayEndpoint;

    public boolean isJarUseMode() {
        return StringUtils.equals((CharSequence)this.dagUseMode, (CharSequence)"jar");
    }

    public String teslaGatewayUrl(String env, String appId, String faasName) {
        if (StringUtils.isEmpty((CharSequence)env)) {
            env = "";
        }
        String urlHeader = "gateway.tesla.alibaba-inc.com";
        switch (env) {
            case "pre": {
                urlHeader = "gateway-pre.tesla.alibaba-inc.com";
                break;
            }
            case "daily": {
                urlHeader = "gateway-daily.tesla.alibaba-inc.com";
                break;
            }
        }
        return String.format(this.teslaGatewayUrl, urlHeader, appId, faasName);
    }

    public String teslaTaskInstance(String appId, String taskId) {
        return String.format(this.teslaTaskInstance, appId, taskId);
    }

    public String getTeslaGatewayEndpoint() {
        return this.teslaGatewayEndpoint;
    }
}

