/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.accordion;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.alibaba.tesla.dag.ApplicationProperties;
import com.alibaba.tesla.dag.accordion.BaseWidgetComponent;
import com.alibaba.tesla.dag.accordion.BaseWidgetJsxComponent;
import com.alibaba.tesla.dag.accordion.CommonDiagnoseComponent;
import com.alibaba.tesla.dag.accordion.CommonDiagnoseStep;
import com.alibaba.tesla.dag.accordion.CommonHighchartComponent;
import com.alibaba.tesla.dag.accordion.CommonKvComponent;
import com.alibaba.tesla.dag.accordion.CommonTableComponent;
import com.alibaba.tesla.dag.accordion.ComponentInterface;
import com.alibaba.tesla.dag.model.domain.TcDag;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.TcDagInstNode;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeFormatType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeType;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.schedule.task.TaskStatus;
import com.alibaba.tesla.dag.services.AbstractActionNewService;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AccordionDagService {
    private static final Logger log = LoggerFactory.getLogger(AccordionDagService.class);
    @Autowired
    TcDagInstRepository dagInstRepository;
    @Autowired
    TcDagInstNodeRepository dagInstNodeRepository;
    @Autowired
    ApplicationProperties ap;
    @Autowired
    TcDagRepository dagRepository;
    @Autowired
    private List<AbstractActionNewService> actionNewServiceList;

    private static List<TcDagInstNode> getNodeList(TcDag dag, Long dagInstId) {
        ArrayList<TcDagInstNode> nodeList = new ArrayList<TcDagInstNode>();
        for (JSONObject nodeJson : dag.nodes()) {
            nodeList.add(AccordionDagService.genNode(dagInstId, nodeJson));
        }
        return nodeList;
    }

    private static TcDagInstNode genNode(Long dagInstId, JSONObject nodeJson) {
        return TcDagInstNode.builder().gmtCreate(System.currentTimeMillis() / 1000L).gmtModified(System.currentTimeMillis() / 1000L).gmtStart(999999999999999L).dagInstId(dagInstId).tcDagContentNodeSpec(JSONObject.toJSONString((Object)nodeJson)).status(DagInstNodeStatus.INIT.toString()).build().updateTcDagOrNodeDetail(nodeJson).updateNodeId();
    }

    public String getDagInstStatus(DagInstStatus status) {
        switch (status) {
            case STOPPED: 
            case EXCEPTION: {
                return "exception";
            }
            case SUCCESS: {
                return "success";
            }
        }
        return "running";
    }

    public List<TcDagInstNode> dagInstNodeListSortWithIndex(TcDag dag, List<TcDagInstNode> dagInstNodeList) {
        Map<String, JSONObject> nodeMap = dag.nodes().stream().collect(Collectors.toMap(x -> x.getString("id"), x -> x));
        return dagInstNodeList.stream().sorted((dagInstNode1, dagInstNode2) -> {
            String nodeId1 = dagInstNode1.getNodeId();
            String nodeId2 = dagInstNode2.getNodeId();
            long nodeIndex1 = ((JSONObject)nodeMap.get(nodeId1)).getLongValue("index");
            long nodeIndex2 = ((JSONObject)nodeMap.get(nodeId2)).getLongValue("index");
            long gmtStart1 = dagInstNode1.getGmtStart();
            long gmtStart2 = dagInstNode2.getGmtStart();
            if (nodeIndex1 == nodeIndex2) {
                return Long.compare(gmtStart1, gmtStart2);
            }
            if (nodeIndex1 < 0L || nodeIndex2 < 0L) {
                return -1 * Long.compare(nodeIndex1, nodeIndex2);
            }
            return Long.compare(nodeIndex1, nodeIndex2);
        }).collect(Collectors.toList());
    }

    public String getDagInstShowStatus(Long dagInstId) {
        if (dagInstId == null) {
            return "waiting";
        }
        TcDagInst dagInst = this.dagInstRepository.findFirstById(dagInstId);
        String status = this.getDagInstStatus(dagInst.status());
        if (!"success".equals(status)) {
            return status;
        }
        List<TcDagInstNode> dagInstNodeList = this.dagInstNodeRepository.findAllByDagInstIdAndNodeIdNotInOrderByGmtStartAsc(dagInstId, Arrays.asList("__pre_node__", "__post_node__"));
        dagInstNodeList = this.dagInstNodeListSortWithIndex(dagInst.dag(), dagInstNodeList);
        ArrayList<String> nodeResultStatusList = new ArrayList<String>();
        for (TcDagInstNode dagInstNode : dagInstNodeList) {
            switch (dagInstNode.type()) {
                case DAG: {
                    nodeResultStatusList.add(this.getDagInstShowStatus(dagInstNode.getSubDagInstId()));
                    break;
                }
                case NODE: {
                    try {
                        JSONObject resultJson = AbstractActionNewService.getDataResult(dagInstNode.outJsonWithCache());
                        nodeResultStatusList.add(resultJson.getString("status"));
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
        }
        if (nodeResultStatusList.contains("ERROR") || nodeResultStatusList.contains("error")) {
            return "error";
        }
        if (nodeResultStatusList.contains("CRITICAL") || nodeResultStatusList.contains("critical")) {
            return "critical";
        }
        if (nodeResultStatusList.contains("WARNING") || nodeResultStatusList.contains("warning")) {
            return "warning";
        }
        return "success";
    }

    public String getDagInstNodeStatus(TcDagInstNode instNode) {
        if (instNode.type() == DagInstNodeType.NODE) {
            switch (instNode.status()) {
                case INIT: 
                case SKIP_CAUSE_BY_EXCEPTION: 
                case SKIP_CAUSE_BY_STOPPED: 
                case SKIP: {
                    return "waiting";
                }
                case STOPPED: 
                case EXCEPTION: {
                    return "exception";
                }
                case SUCCESS: {
                    return "success";
                }
            }
            return "running";
        }
        return this.getDagInstShowStatus(instNode.getSubDagInstId());
    }

    public CommonDiagnoseComponent getDag(Long dagId, String locale) {
        TcDag dag = this.dagRepository.findFirstById(dagId);
        CommonDiagnoseComponent commonDiagnoseComponent = CommonDiagnoseComponent.builder().summary(CommonKvComponent.builder().build()).build();
        List<CommonDiagnoseStep> steps = commonDiagnoseComponent.getSteps();
        for (TcDagInstNode dagInstNode : AccordionDagService.getNodeList(dag, null)) {
            String alias = dagInstNode.alias();
            switch (dagInstNode.type()) {
                case NODE: {
                    TcDagNode dagNode = dagInstNode.dagNode();
                    dagNode.obtainOptions(locale);
                    alias = dagNode.alias();
                    break;
                }
                case DAG: {
                    TcDag subDag = this.dagRepository.findFirstById(dagInstNode.defId());
                    subDag.obtainOptions(locale);
                    alias = subDag.alias();
                    break;
                }
            }
            steps.add(CommonDiagnoseStep.builder().name(alias).status("waiting").build());
        }
        return commonDiagnoseComponent;
    }

    public void cacheNodeOutJson(List<TcDagInstNode> dagInstNodeList) {
        dagInstNodeList.parallelStream().forEach(x -> {
            try {
                if (x.isEnd() && StringUtils.isNotEmpty((CharSequence)x.getTaskId()) && x.type() == DagInstNodeType.NODE) {
                    x.outJsonWithCache();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public CommonDiagnoseComponent getDagInst(Long dagInstId, String locale) throws Exception {
        TcDagInstNode postNode;
        TcDagInst dagInst = this.dagInstRepository.findFirstById(dagInstId);
        if (dagInst == null) {
            throw new Exception("not exist dagInstId: " + dagInstId);
        }
        TcDagInst lastDagInst = this.dagInstRepository.findFirstByDagIdAndStatusOrderByGmtCreateDesc(dagInst.getDagId(), DagInstStatus.SUCCESS.name());
        CommonKvComponent summary = CommonKvComponent.builder().submitter(dagInst.getCreator()).stime(dagInst.getGmtCreate()).etime(dagInst.getGmtModified()).status(this.getDagInstShowStatus(dagInstId)).build();
        if (lastDagInst != null) {
            summary.estimatedDuration = lastDagInst.getGmtAccess() - lastDagInst.getGmtCreate();
        }
        if ((postNode = dagInst.postNode()) != null) {
            summary.setDetail(this.getDagInstNode(postNode, locale));
            if (postNode.status() == DagInstNodeStatus.SUCCESS) {
                summary.setDescription(dagInst.globalResultJson().getJSONObject("__post_node__").getJSONObject("result").getString("description"));
            }
        }
        CommonDiagnoseComponent commonDiagnoseComponent = CommonDiagnoseComponent.builder().summary(summary).build();
        if (StringUtils.isNotEmpty((CharSequence)dagInst.getStatusDetail())) {
            summary.addKv("\u9519\u8bef\u4fe1\u606f", dagInst.getStatusDetail());
        }
        List<TcDagInstNode> dagInstPrePostNodeList = this.dagInstNodeRepository.findAllByDagInstIdAndNodeIdInOrderByGmtStartAsc(dagInstId, Arrays.asList("__pre_node__", "__post_node__"));
        for (TcDagInstNode node : dagInstPrePostNodeList) {
            String name;
            String taskId = node.getTaskId();
            String nodeId = node.nodeId();
            String string = name = nodeId.contains("pre") ? "pre\u8282\u70b9" : "post\u8282\u70b9";
            if (!StringUtils.isNotEmpty((CharSequence)taskId) || node.status() == DagInstNodeStatus.SUCCESS) continue;
            summary.addLinkKv(name, this.ap.teslaTaskInstance(dagInst.getAppId(), taskId), "\u8be6\u60c5");
        }
        List<CommonDiagnoseStep> steps = commonDiagnoseComponent.getSteps();
        List<TcDagInstNode> dagInstNodeList = this.dagInstNodeRepository.findAllByDagInstIdAndNodeIdNotInOrderByGmtStartAsc(dagInstId, Arrays.asList("__pre_node__", "__post_node__"));
        dagInstNodeList = this.dagInstNodeListSortWithIndex(dagInst.dag(), dagInstNodeList);
        this.cacheNodeOutJson(dagInstNodeList);
        for (TcDagInstNode dagInstNode : dagInstNodeList) {
            JSONObject globalResultJson;
            Long taskId;
            if (dagInstNode.status() == DagInstNodeStatus.SKIP) continue;
            if (dagInstNode.type() == DagInstNodeType.NODE && !dagInstNode.dagNode().show() && (taskId = dagInstNode.taskId()) != null) {
                DagNodeType dagNodeType = dagInstNode.dagNode().type();
                AbstractActionNewService abstractActionNewService = this.actionNewServiceList.stream().filter(actionNewService -> actionNewService.registerNodeType() == dagNodeType).findFirst().orElse(null);
                TaskStatus status = abstractActionNewService.status(taskId);
                if (status != TaskStatus.EXCEPTION) continue;
            }
            ArrayList<ComponentInterface> detail = new ArrayList<ComponentInterface>();
            List<ComponentInterface> detailFromNode = this.getDagInstNode(dagInstNode, locale);
            CommonDiagnoseStep step = CommonDiagnoseStep.builder().name(dagInstNode.alias()).nodeId(dagInstNode.nodeId()).status(this.getDagInstNodeStatus(dagInstNode)).logInfo(dagInstNode.getStatusDetail()).detail(detail).build();
            if (dagInstNode.type() == DagInstNodeType.DAG && dagInstNode.status() == DagInstNodeStatus.SUCCESS && (globalResultJson = dagInstNode.subDagInst().globalResultJson()).containsKey((Object)"__post_node__")) {
                step.setDescription(globalResultJson.getJSONObject("__post_node__").getJSONObject("result").getString("description"));
            }
            if (dagInstNode.type() == DagInstNodeType.NODE && dagInstNode.status() == DagInstNodeStatus.SUCCESS) {
                try {
                    JSONObject resultJson = AbstractActionNewService.getDataResult(dagInstNode.outJsonWithCache());
                    step.setDescription(resultJson.getString("description"));
                    switch (resultJson.getString("status")) {
                        case "OK": {
                            step.setStatus("success");
                            break;
                        }
                        case "ERROR": {
                            step.setStatus("error");
                            break;
                        }
                        case "CRITICAL": {
                            step.setStatus("critical");
                            break;
                        }
                        case "WARNING": {
                            step.setStatus("warning");
                            break;
                        }
                        default: {
                            step.setStatus("exception");
                        }
                    }
                    Object taskAppId = JSONObject.parseObject((String)dagInstNode.dagNode().detail().toJson()).getOrDefault((Object)"appId", (Object)dagInst.getAppId());
                    CommonKvComponent commonKvComponent = new CommonKvComponent().isSummary(false);
                    if (StringUtils.isNotEmpty((CharSequence)resultJson.getString("message"))) {
                        commonKvComponent.addKv("\u8bca\u65ad\u7ed3\u679c", resultJson.get((Object)"message"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)resultJson.getString("action"))) {
                        commonKvComponent.addKv("\u8bca\u65ad\u5efa\u8bae", resultJson.get((Object)"action"));
                    }
                    if (!dagInstNode.dagNode().type().equals((Object)DagNodeType.LOCAL) && dagInstNode.status() != DagInstNodeStatus.SUCCESS) {
                        commonKvComponent.addLinkKv("\u4f5c\u4e1a", this.ap.teslaTaskInstance((String)taskAppId, dagInstNode.getTaskId()), "\u67e5\u770b");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)resultJson.getString("name"))) {
                        step.setName(resultJson.getString("name"));
                    }
                    detail.add(commonKvComponent);
                }
                catch (Exception e) {
                    detail.add(BaseWidgetJsxComponent.builder().text("get output error: " + Throwables.getStackTraceAsString((Throwable)e)).build());
                }
            }
            detail.addAll(detailFromNode);
            steps.add(step);
        }
        return commonDiagnoseComponent;
    }

    public List<ComponentInterface> getDagInstNode(TcDagInstNode dagInstNode, String locale) {
        if (dagInstNode.status() == DagInstNodeStatus.INIT) {
            return Collections.singletonList(BaseWidgetJsxComponent.builder().text("wait for run").build());
        }
        try {
            switch (dagInstNode.type()) {
                case DAG: {
                    switch (dagInstNode.status()) {
                        case SKIP_CAUSE_BY_EXCEPTION: 
                        case SKIP_CAUSE_BY_STOPPED: 
                        case SKIP: 
                        case STOPPED: {
                            return Collections.singletonList(BaseWidgetJsxComponent.builder().text(dagInstNode.status().name()).build());
                        }
                    }
                    TcDagInst dagInst = dagInstNode.subDagInst();
                    return Collections.singletonList(this.getDagInst(dagInst.getId(), locale));
                }
                case NODE: {
                    switch (dagInstNode.status()) {
                        case INIT: 
                        case RUNNING: 
                        case STOPPING: 
                        case WAIT_STOP: {
                            BaseWidgetJsxComponent bwjc = BaseWidgetJsxComponent.builder().build();
                            bwjc.addText("running, please wait");
                            if (StringUtils.isNotEmpty((CharSequence)dagInstNode.getTaskId()) && !dagInstNode.dagNode().type().equals((Object)DagNodeType.LOCAL)) {
                                String a = String.format("<a href=\"%s\" target=\"_blank\">\u8be6\u60c5</a>", this.ap.teslaTaskInstance(dagInstNode.dagInst().getAppId(), dagInstNode.getTaskId()));
                                bwjc.addHtmlText(a, "\n");
                            }
                            return Collections.singletonList(bwjc);
                        }
                        case EXCEPTION: {
                            BaseWidgetJsxComponent bwjc = BaseWidgetJsxComponent.builder().build();
                            bwjc.addText("exception: " + dagInstNode.getStatusDetail());
                            if (StringUtils.isNotEmpty((CharSequence)dagInstNode.getTaskId()) && !dagInstNode.dagNode().type().equals((Object)DagNodeType.LOCAL)) {
                                String a = String.format("<a href=\"%s\" target=\"_blank\">\u8be6\u60c5</a>", this.ap.teslaTaskInstance(dagInstNode.dagInst().getAppId(), dagInstNode.getTaskId()));
                                bwjc.addHtmlText(a, "\n");
                            }
                            return Collections.singletonList(bwjc);
                        }
                        case SKIP_CAUSE_BY_EXCEPTION: 
                        case SKIP_CAUSE_BY_STOPPED: 
                        case SKIP: 
                        case STOPPED: {
                            return Collections.singletonList(BaseWidgetJsxComponent.builder().text(dagInstNode.status().name()).build());
                        }
                    }
                    DagNodeFormatType dagNodeFormatType = dagInstNode.dagNode().formatType();
                    switch (dagNodeFormatType) {
                        case METRIC: 
                        case KV: 
                        case TABLE: 
                        case SIMPLE_CUSTOM: {
                            ArrayList<ComponentInterface> retList = new ArrayList<ComponentInterface>();
                            JSONArray formatDetailArray = new JSONArray();
                            try {
                                formatDetailArray = JSONObject.parseArray((String)dagInstNode.dagNode().getFormatDetail());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            JSONArray dataArray = AbstractActionNewService.getDataData(dagInstNode.outJsonWithCache(), JSONArray.class);
                            dataArray = dataArray == null ? new JSONArray() : dataArray;
                            for (int index = 0; index < dataArray.size(); ++index) {
                                JSONObject formatDetailJson = !CollectionUtils.isEmpty((Collection)formatDetailArray) && formatDetailArray.size() > index ? formatDetailArray.getJSONObject(index) : new JSONObject();
                                Object dataObject = dataArray.get(index);
                                retList.add(this.getComponentInterface(dagInstNode.getId(), dagNodeFormatType, dataObject, formatDetailJson));
                            }
                            return retList;
                        }
                        case CUSTOM: {
                            String elementOutUrl = String.format(this.ap.teslaCheckUrl + "/dagInstNode/elementOut?dagInstNodeId=%s", dagInstNode.getId());
                            String formatDetail = dagInstNode.dagNode().getFormatDetail();
                            formatDetail = StringUtils.isEmpty((CharSequence)formatDetail) ? "" : formatDetail.replace("${elementOutUrl}", elementOutUrl);
                            return Collections.singletonList(BaseWidgetComponent.builder().formatDetail(formatDetail).build());
                        }
                    }
                    return Collections.singletonList(BaseWidgetJsxComponent.builder().text("dagInstNode can not support formatType: " + (Object)((Object)dagNodeFormatType)).build());
                }
            }
            return Collections.singletonList(BaseWidgetJsxComponent.builder().text("dagInstNode can not support type: " + (Object)((Object)dagInstNode.type())).build());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Collections.singletonList(BaseWidgetJsxComponent.builder().text("dagInstNode show error: " + Throwables.getStackTraceAsString((Throwable)e)).build());
        }
    }

    public ComponentInterface getComponentInterface(Long dagInstNodeId, DagNodeFormatType nodeFormatType, Object dataObject, JSONObject formatDetailJson) {
        switch (nodeFormatType) {
            case TABLE: {
                JSONArray dataArray = (JSONArray)TypeUtils.castToJavaBean((Object)dataObject, JSONArray.class);
                return CommonTableComponent.builder().rowData(dataArray.toJavaList(JSONObject.class)).build().setColumnDefs(dataArray, formatDetailJson);
            }
            case KV: {
                LinkedHashMap<String, Object> dataLinkedHashMap = this.castToLinkedHashMap(dataObject);
                return CommonKvComponent.builder().kvData(dataLinkedHashMap).build().isSummary(false);
            }
            case METRIC: {
                LinkedHashMap<String, Object> dataLinkedHashMap = this.castToLinkedHashMap(dataObject);
                return CommonHighchartComponent.builder().data(dataLinkedHashMap).build();
            }
            case SIMPLE_CUSTOM: {
                DagNodeFormatType type;
                if (CollectionUtils.isEmpty((Map)formatDetailJson)) {
                    return BaseWidgetJsxComponent.builder().text("do not define format detail for this part").build();
                }
                JSONObject detail = formatDetailJson.getJSONObject("detail");
                try {
                    type = (DagNodeFormatType)((Object)formatDetailJson.getObject("type", DagNodeFormatType.class));
                }
                catch (Exception e) {
                    return BaseWidgetJsxComponent.builder().build().addText("get type error").addErrorToText(e);
                }
                return this.getComponentInterface(dagInstNodeId, type, dataObject, detail);
            }
            case CUSTOM: {
                String elementOutUrl = String.format(this.ap.teslaCheckUrl + "/dagInstNode/elementOut?dagInstNodeId=%s", dagInstNodeId);
                String formatDetail = JSONObject.toJSONString((Object)formatDetailJson);
                formatDetail = StringUtils.isEmpty((CharSequence)formatDetail) ? "" : formatDetail.replace("${elementOutUrl}", elementOutUrl);
                return BaseWidgetComponent.builder().formatDetail(formatDetail).build();
            }
        }
        return BaseWidgetJsxComponent.builder().build().addText("do not support type: " + nodeFormatType.name());
    }

    private LinkedHashMap<String, Object> castToLinkedHashMap(Object o) {
        return (LinkedHashMap)TypeUtils.castToJavaBean((Object)o, LinkedHashMap.class);
    }
}

