/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.accordion;

import com.alibaba.tesla.dag.accordion.ComponentInterface;
import com.alibaba.tesla.dag.common.Tools;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonKvComponent
implements ComponentInterface {
    private static final Logger log = LoggerFactory.getLogger(CommonKvComponent.class);
    List<ComponentInterface> detail;
    String description;
    boolean isSummary;
    String submitter;
    Long stime;
    Long etime;
    Long estimatedDuration;
    String status;
    LinkedHashMap<String, Object> kvData;

    public CommonKvComponent isSummary(boolean isSummary) {
        this.isSummary = isSummary;
        return this;
    }

    public CommonKvComponent(String submitter, Long stime, Long etime, Long estimatedDuration, String status) {
        this.submitter = submitter;
        this.stime = stime;
        this.etime = etime;
        if (estimatedDuration != null) {
            this.estimatedDuration = estimatedDuration;
        }
        this.status = status;
    }

    public CommonKvComponent addLinkKv(String name, String href, Object value) {
        this.kvData.put(name, ImmutableMap.of((Object)"href", (Object)href, (Object)"type", (Object)"link", (Object)"value", (Object)value));
        return this;
    }

    public CommonKvComponent addKv(String name, Object value) {
        this.kvData.put(name, value);
        return this;
    }

    private Map<String, Object> getMetaData() {
        return ImmutableMap.of((Object)"submitter", (Object)this.submitter, (Object)"stime", (Object)(this.stime != null ? Tools.timeStamp2Date(this.stime) : ""), (Object)"etime", (Object)(this.etime != null ? Tools.timeStamp2Date(this.etime) : ""), (Object)"estimated_duration", (Object)this.estimatedDuration, (Object)"status", (Object)this.status);
    }

    private Map<String, Object> getAllKvData() {
        LinkedHashMap<String, Object> allData = new LinkedHashMap<String, Object>();
        if (this.isSummary) {
            allData.putAll(this.getMetaData());
        }
        allData.putAll(this.kvData);
        return allData;
    }

    @Override
    public Map<String, Object> toMap() {
        return ImmutableMap.of((Object)"component", (Object)"CommonKvComponent", (Object)"props", (Object)ImmutableMap.of((Object)"kvData", this.getAllKvData(), (Object)"colNum", (Object)2), (Object)"description", (Object)this.description, (Object)"detail", this.detail == null ? new ArrayList() : this.detail.stream().map(ComponentInterface::toMap).collect(Collectors.toList()));
    }

    private static List<ComponentInterface> $default$detail() {
        return new ArrayList<ComponentInterface>();
    }

    private static String $default$description() {
        return "";
    }

    private static boolean $default$isSummary() {
        return true;
    }

    private static String $default$submitter() {
        return "";
    }

    private static Long $default$estimatedDuration() {
        return 120L;
    }

    private static String $default$status() {
        return "waiting";
    }

    private static LinkedHashMap<String, Object> $default$kvData() {
        return new LinkedHashMap<String, Object>();
    }

    public static CommonKvComponentBuilder builder() {
        return new CommonKvComponentBuilder();
    }

    public List<ComponentInterface> getDetail() {
        return this.detail;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSummary() {
        return this.isSummary;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public Long getStime() {
        return this.stime;
    }

    public Long getEtime() {
        return this.etime;
    }

    public Long getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public String getStatus() {
        return this.status;
    }

    public LinkedHashMap<String, Object> getKvData() {
        return this.kvData;
    }

    public void setDetail(List<ComponentInterface> detail) {
        this.detail = detail;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSummary(boolean isSummary) {
        this.isSummary = isSummary;
    }

    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    public void setStime(Long stime) {
        this.stime = stime;
    }

    public void setEtime(Long etime) {
        this.etime = etime;
    }

    public void setEstimatedDuration(Long estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setKvData(LinkedHashMap<String, Object> kvData) {
        this.kvData = kvData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonKvComponent)) {
            return false;
        }
        CommonKvComponent other = (CommonKvComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ComponentInterface> this$detail = this.getDetail();
        List<ComponentInterface> other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !((Object)this$detail).equals(other$detail)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (this.isSummary() != other.isSummary()) {
            return false;
        }
        String this$submitter = this.getSubmitter();
        String other$submitter = other.getSubmitter();
        if (this$submitter == null ? other$submitter != null : !this$submitter.equals(other$submitter)) {
            return false;
        }
        Long this$stime = this.getStime();
        Long other$stime = other.getStime();
        if (this$stime == null ? other$stime != null : !((Object)this$stime).equals(other$stime)) {
            return false;
        }
        Long this$etime = this.getEtime();
        Long other$etime = other.getEtime();
        if (this$etime == null ? other$etime != null : !((Object)this$etime).equals(other$etime)) {
            return false;
        }
        Long this$estimatedDuration = this.getEstimatedDuration();
        Long other$estimatedDuration = other.getEstimatedDuration();
        if (this$estimatedDuration == null ? other$estimatedDuration != null : !((Object)this$estimatedDuration).equals(other$estimatedDuration)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        LinkedHashMap<String, Object> this$kvData = this.getKvData();
        LinkedHashMap<String, Object> other$kvData = other.getKvData();
        return !(this$kvData == null ? other$kvData != null : !((Object)this$kvData).equals(other$kvData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonKvComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ComponentInterface> $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : ((Object)$detail).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + (this.isSummary() ? 79 : 97);
        String $submitter = this.getSubmitter();
        result = result * 59 + ($submitter == null ? 43 : $submitter.hashCode());
        Long $stime = this.getStime();
        result = result * 59 + ($stime == null ? 43 : ((Object)$stime).hashCode());
        Long $etime = this.getEtime();
        result = result * 59 + ($etime == null ? 43 : ((Object)$etime).hashCode());
        Long $estimatedDuration = this.getEstimatedDuration();
        result = result * 59 + ($estimatedDuration == null ? 43 : ((Object)$estimatedDuration).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        LinkedHashMap<String, Object> $kvData = this.getKvData();
        result = result * 59 + ($kvData == null ? 43 : ((Object)$kvData).hashCode());
        return result;
    }

    public String toString() {
        return "CommonKvComponent(detail=" + this.getDetail() + ", description=" + this.getDescription() + ", isSummary=" + this.isSummary() + ", submitter=" + this.getSubmitter() + ", stime=" + this.getStime() + ", etime=" + this.getEtime() + ", estimatedDuration=" + this.getEstimatedDuration() + ", status=" + this.getStatus() + ", kvData=" + this.getKvData() + ")";
    }

    public CommonKvComponent(List<ComponentInterface> detail, String description, boolean isSummary, String submitter, Long stime, Long etime, Long estimatedDuration, String status, LinkedHashMap<String, Object> kvData) {
        this.detail = detail;
        this.description = description;
        this.isSummary = isSummary;
        this.submitter = submitter;
        this.stime = stime;
        this.etime = etime;
        this.estimatedDuration = estimatedDuration;
        this.status = status;
        this.kvData = kvData;
    }

    public CommonKvComponent() {
        this.detail = CommonKvComponent.$default$detail();
        this.description = CommonKvComponent.$default$description();
        this.isSummary = CommonKvComponent.$default$isSummary();
        this.submitter = CommonKvComponent.$default$submitter();
        this.estimatedDuration = CommonKvComponent.$default$estimatedDuration();
        this.status = CommonKvComponent.$default$status();
        this.kvData = CommonKvComponent.$default$kvData();
    }

    public static class CommonKvComponentBuilder {
        private boolean detail$set;
        private List<ComponentInterface> detail;
        private boolean description$set;
        private String description;
        private boolean isSummary$set;
        private boolean isSummary;
        private boolean submitter$set;
        private String submitter;
        private Long stime;
        private Long etime;
        private boolean estimatedDuration$set;
        private Long estimatedDuration;
        private boolean status$set;
        private String status;
        private boolean kvData$set;
        private LinkedHashMap<String, Object> kvData;

        CommonKvComponentBuilder() {
        }

        public CommonKvComponentBuilder detail(List<ComponentInterface> detail) {
            this.detail = detail;
            this.detail$set = true;
            return this;
        }

        public CommonKvComponentBuilder description(String description) {
            this.description = description;
            this.description$set = true;
            return this;
        }

        public CommonKvComponentBuilder isSummary(boolean isSummary) {
            this.isSummary = isSummary;
            this.isSummary$set = true;
            return this;
        }

        public CommonKvComponentBuilder submitter(String submitter) {
            this.submitter = submitter;
            this.submitter$set = true;
            return this;
        }

        public CommonKvComponentBuilder stime(Long stime) {
            this.stime = stime;
            return this;
        }

        public CommonKvComponentBuilder etime(Long etime) {
            this.etime = etime;
            return this;
        }

        public CommonKvComponentBuilder estimatedDuration(Long estimatedDuration) {
            this.estimatedDuration = estimatedDuration;
            this.estimatedDuration$set = true;
            return this;
        }

        public CommonKvComponentBuilder status(String status) {
            this.status = status;
            this.status$set = true;
            return this;
        }

        public CommonKvComponentBuilder kvData(LinkedHashMap<String, Object> kvData) {
            this.kvData = kvData;
            this.kvData$set = true;
            return this;
        }

        public CommonKvComponent build() {
            List detail = this.detail;
            if (!this.detail$set) {
                detail = CommonKvComponent.$default$detail();
            }
            String description = this.description;
            if (!this.description$set) {
                description = CommonKvComponent.$default$description();
            }
            boolean isSummary = this.isSummary;
            if (!this.isSummary$set) {
                isSummary = CommonKvComponent.$default$isSummary();
            }
            String submitter = this.submitter;
            if (!this.submitter$set) {
                submitter = CommonKvComponent.$default$submitter();
            }
            Long estimatedDuration = this.estimatedDuration;
            if (!this.estimatedDuration$set) {
                estimatedDuration = CommonKvComponent.$default$estimatedDuration();
            }
            String status = this.status;
            if (!this.status$set) {
                status = CommonKvComponent.$default$status();
            }
            LinkedHashMap kvData = this.kvData;
            if (!this.kvData$set) {
                kvData = CommonKvComponent.$default$kvData();
            }
            return new CommonKvComponent(detail, description, isSummary, submitter, this.stime, this.etime, estimatedDuration, status, kvData);
        }

        public String toString() {
            return "CommonKvComponent.CommonKvComponentBuilder(detail=" + this.detail + ", description=" + this.description + ", isSummary=" + this.isSummary + ", submitter=" + this.submitter + ", stime=" + this.stime + ", etime=" + this.etime + ", estimatedDuration=" + this.estimatedDuration + ", status=" + this.status + ", kvData=" + this.kvData + ")";
        }
    }
}

