/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.accordion;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.accordion.CommonTableColumnDef;
import com.alibaba.tesla.dag.accordion.ComponentInterface;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CommonTableComponent
implements ComponentInterface {
    private static final Logger log = LoggerFactory.getLogger(CommonTableComponent.class);
    List<JSONObject> rowData;
    List<CommonTableColumnDef> columnDefs;

    public CommonTableComponent setColumnDefs(JSONArray dataArray, JSONObject formatDetailJson) {
        JSONObject jSONObject = formatDetailJson = CollectionUtils.isEmpty((Map)formatDetailJson) ? new JSONObject() : formatDetailJson;
        if (!CollectionUtils.isEmpty((Collection)dataArray)) {
            LinkedHashMap map = (LinkedHashMap)dataArray.getObject(0, LinkedHashMap.class);
            ArrayList keys = new ArrayList(map.keySet());
            for (String key : keys) {
                CommonTableColumnDef columnDef = CommonTableColumnDef.builder().headerName(key).field(key).tooltip("").build().span();
                if (formatDetailJson.containsKey((Object)key)) {
                    JSONObject keyJson;
                    columnDef.render = keyJson = formatDetailJson.getJSONObject(key);
                    if (keyJson.containsKey((Object)"headerName")) {
                        columnDef.headerName = keyJson.getString("headerName");
                    }
                    if (keyJson.containsKey((Object)"_tooltip")) {
                        columnDef.tooltip = keyJson.getString("_tooltip");
                    }
                    if (keyJson.containsKey((Object)"_filter")) {
                        columnDef.filter = keyJson.get((Object)"_filter");
                    }
                    if (keyJson.containsKey((Object)"_hide")) {
                        columnDef.hide = keyJson.getBooleanValue("_hide");
                    }
                }
                this.columnDefs.add(columnDef);
            }
        }
        return this;
    }

    @Override
    public Map<String, Object> toMap() {
        return ImmutableMap.of((Object)"component", (Object)"CommonTableComponent", (Object)"props", (Object)ImmutableMap.of((Object)"rowData", this.rowData, (Object)"columnDefs", this.columnDefs.stream().map(CommonTableColumnDef::toMap).collect(Collectors.toList())));
    }

    private static List<JSONObject> $default$rowData() {
        return new ArrayList<JSONObject>();
    }

    private static List<CommonTableColumnDef> $default$columnDefs() {
        return new ArrayList<CommonTableColumnDef>();
    }

    public static CommonTableComponentBuilder builder() {
        return new CommonTableComponentBuilder();
    }

    public List<JSONObject> getRowData() {
        return this.rowData;
    }

    public List<CommonTableColumnDef> getColumnDefs() {
        return this.columnDefs;
    }

    public void setRowData(List<JSONObject> rowData) {
        this.rowData = rowData;
    }

    public void setColumnDefs(List<CommonTableColumnDef> columnDefs) {
        this.columnDefs = columnDefs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonTableComponent)) {
            return false;
        }
        CommonTableComponent other = (CommonTableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<JSONObject> this$rowData = this.getRowData();
        List<JSONObject> other$rowData = other.getRowData();
        if (this$rowData == null ? other$rowData != null : !((Object)this$rowData).equals(other$rowData)) {
            return false;
        }
        List<CommonTableColumnDef> this$columnDefs = this.getColumnDefs();
        List<CommonTableColumnDef> other$columnDefs = other.getColumnDefs();
        return !(this$columnDefs == null ? other$columnDefs != null : !((Object)this$columnDefs).equals(other$columnDefs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonTableComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<JSONObject> $rowData = this.getRowData();
        result = result * 59 + ($rowData == null ? 43 : ((Object)$rowData).hashCode());
        List<CommonTableColumnDef> $columnDefs = this.getColumnDefs();
        result = result * 59 + ($columnDefs == null ? 43 : ((Object)$columnDefs).hashCode());
        return result;
    }

    public String toString() {
        return "CommonTableComponent(rowData=" + this.getRowData() + ", columnDefs=" + this.getColumnDefs() + ")";
    }

    public CommonTableComponent(List<JSONObject> rowData, List<CommonTableColumnDef> columnDefs) {
        this.rowData = rowData;
        this.columnDefs = columnDefs;
    }

    public CommonTableComponent() {
        this.rowData = CommonTableComponent.$default$rowData();
        this.columnDefs = CommonTableComponent.$default$columnDefs();
    }

    public static class CommonTableComponentBuilder {
        private boolean rowData$set;
        private List<JSONObject> rowData;
        private boolean columnDefs$set;
        private List<CommonTableColumnDef> columnDefs;

        CommonTableComponentBuilder() {
        }

        public CommonTableComponentBuilder rowData(List<JSONObject> rowData) {
            this.rowData = rowData;
            this.rowData$set = true;
            return this;
        }

        public CommonTableComponentBuilder columnDefs(List<CommonTableColumnDef> columnDefs) {
            this.columnDefs = columnDefs;
            this.columnDefs$set = true;
            return this;
        }

        public CommonTableComponent build() {
            List rowData = this.rowData;
            if (!this.rowData$set) {
                rowData = CommonTableComponent.$default$rowData();
            }
            List columnDefs = this.columnDefs;
            if (!this.columnDefs$set) {
                columnDefs = CommonTableComponent.$default$columnDefs();
            }
            return new CommonTableComponent(rowData, columnDefs);
        }

        public String toString() {
            return "CommonTableComponent.CommonTableComponentBuilder(rowData=" + this.rowData + ", columnDefs=" + this.columnDefs + ")";
        }
    }
}

