/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.algorithm;

import com.alibaba.tesla.dag.algorithm.LinkedHashSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public final class DAG {
    private final LinkedHashSetMultimap outDegree;
    private final LinkedHashSetMultimap inDegree;

    public DAG(LinkedHashSetMultimap outDegree, LinkedHashSetMultimap inDegree) {
        this.outDegree = outDegree;
        this.inDegree = inDegree;
    }

    public boolean isCircularity() {
        Map<Object, AtomicInteger> inDegree = this.getObjectAtomicIntegerMap();
        Set sources = this.getSources();
        LinkedList queue = new LinkedList();
        queue.addAll(sources);
        while (!queue.isEmpty()) {
            Object o = queue.removeFirst();
            this.outDegree.get(o).forEach(so -> {
                if (((AtomicInteger)inDegree.get(so)).decrementAndGet() == 0) {
                    queue.add(so);
                }
            });
        }
        return inDegree.values().stream().filter(x -> x.intValue() > 0).count() > 0L;
    }

    private void chain_(Set sources, LinkedHashSetMultimap foutChain, LinkedHashSetMultimap finChain) {
        sources.forEach(sourceNode -> {
            ArrayList maxStage = Lists.newArrayList();
            this.findMaxStage(sourceNode, maxStage);
            if (maxStage.size() > 1) {
                this.addVertex(foutChain, finChain, maxStage);
                Object o = maxStage.get(maxStage.size() - 1);
                this.reChain_(foutChain, finChain, maxStage, o);
            }
            if (maxStage.size() == 1) {
                this.addVertex(foutChain, finChain, sourceNode);
                Set subNodes = this.outDegree.get(sourceNode);
                this.addSubNodeage(foutChain, finChain, sourceNode, subNodes);
            }
        });
    }

    private void addSubNodeage(LinkedHashSetMultimap foutChain, LinkedHashSetMultimap finChain, Object sourceNode, Set subNodes) {
        if (CollectionUtils.isNotEmpty((Collection)subNodes)) {
            subNodes.forEach(snode -> this.addEdge(foutChain, finChain, sourceNode, snode));
            this.chain_(subNodes, foutChain, finChain);
        } else {
            this.addVertex(foutChain, finChain, sourceNode);
        }
    }

    private void reChain_(LinkedHashSetMultimap foutChain, LinkedHashSetMultimap finChain, ArrayList<Object> maxStage, Object o) {
        Set set = this.outDegree.get(o);
        Object header = maxStage.get(0);
        Set parentSet = finChain.get(header);
        if (CollectionUtils.isNotEmpty((Collection)parentSet)) {
            parentSet.forEach(h -> {
                this.removeEage(foutChain, finChain, h, header);
                this.addEdge(foutChain, finChain, h, maxStage);
            });
        }
        this.addSubNodeage(foutChain, finChain, maxStage, set);
    }

    public void findMaxStage(Object o, List maxStage) {
        Object subNode;
        maxStage.add(o);
        Set setOut = this.outDegree.get(o);
        if (setOut.size() == 1 && this.inDegree.get(subNode = setOut.iterator().next()).size() == 1) {
            this.findMaxStage(subNode, maxStage);
        }
    }

    public DAG chain() {
        Set sources = this.getSources();
        LinkedHashSetMultimap outDegreeChain = new LinkedHashSetMultimap();
        LinkedHashSetMultimap inDegreeChain = new LinkedHashSetMultimap();
        this.chain_(sources, outDegreeChain, inDegreeChain);
        return new DAG(outDegreeChain, inDegreeChain);
    }

    public void execute(Consumer consumer) {
        Map<Object, AtomicInteger> inDegree = this.getObjectAtomicIntegerMap();
        Set sources = this.getSources();
        this.execute_(sources, inDegree, consumer);
    }

    private Map<Object, AtomicInteger> getObjectAtomicIntegerMap() {
        Set set = this.inDegree.keySet();
        return set.stream().collect(Collectors.toMap(k -> k, k -> new AtomicInteger(this.inDegree.get(k).size())));
    }

    public void execute_(Set set, Map<Object, AtomicInteger> inDegree, Consumer consumer) {
        this.exec(set, consumer);
        LinkedHashSet nextSet = Sets.newLinkedHashSet();
        set.forEach(o -> this.outDegree.get(o).forEach(so -> {
            if (((AtomicInteger)inDegree.get(so)).decrementAndGet() == 0) {
                nextSet.add(so);
            }
        }));
        if (CollectionUtils.isNotEmpty((Collection)nextSet)) {
            this.execute_(nextSet, inDegree, consumer);
        }
    }

    private void exec(Set set, Consumer consumer) {
        consumer.accept(set);
    }

    public boolean addEdge(Object origin, Object target) {
        if (this.hasPath(target, origin)) {
            return false;
        }
        this.addEdgeWithNoCheck(origin, target);
        return true;
    }

    public boolean addEdgeWithNoCheck(Object origin, Object target) {
        this.outDegree.put(origin, target);
        this.outDegree.put(target, null);
        this.inDegree.put(target, origin);
        this.inDegree.put(origin, null);
        return true;
    }

    private boolean addEdge(LinkedHashSetMultimap fOut, LinkedHashSetMultimap fIn, Object origin, Object target) {
        fOut.put(origin, target);
        fIn.put(target, origin);
        return true;
    }

    public boolean removeEage(LinkedHashSetMultimap fOut, LinkedHashSetMultimap fIn, Object origin, Object target) {
        fOut.remove(origin, target);
        if (CollectionUtils.isEmpty((Collection)fOut.get(origin))) {
            fOut.removeAll(origin);
        }
        fIn.remove(target, origin);
        if (CollectionUtils.isEmpty((Collection)fIn.get(target))) {
            fIn.removeAll(target);
        }
        return true;
    }

    public void addVertex(Object vertex) {
        this.outDegree.put(vertex, null);
        this.inDegree.put(vertex, null);
    }

    private void addVertex(LinkedHashSetMultimap fOut, LinkedHashSetMultimap fIn, Object vertex) {
        fOut.put(vertex, null);
        fIn.put(vertex, null);
    }

    public void removeVertex(Object vertex) {
        Set targets = this.outDegree.removeAll(vertex);
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            this.inDegree.remove(it.next(), vertex);
        }
        Set origins = this.inDegree.removeAll(vertex);
        Iterator it2 = origins.iterator();
        while (it2.hasNext()) {
            this.outDegree.remove(it2.next(), vertex);
        }
    }

    public Set getSources() {
        return this.computeZeroEdgeVertices(this.inDegree);
    }

    public Set getSinks() {
        return this.computeZeroEdgeVertices(this.outDegree);
    }

    public List topologySort() {
        Map<Object, AtomicInteger> inDegree = this.getObjectAtomicIntegerMap();
        Set sources = this.getSources();
        LinkedList queue = new LinkedList();
        queue.addAll(sources);
        ArrayList topologyList = new ArrayList();
        while (!queue.isEmpty()) {
            Object o = queue.removeFirst();
            topologyList.add(o);
            this.outDegree.get(o).forEach(so -> {
                if (((AtomicInteger)inDegree.get(so)).decrementAndGet() == 0) {
                    queue.add(so);
                }
            });
        }
        return topologyList;
    }

    private Set computeZeroEdgeVertices(LinkedHashSetMultimap map) {
        Set candidates = map.keySet();
        LinkedHashSet roots = new LinkedHashSet(candidates.size());
        for (Object candidate : candidates) {
            if (!map.get(candidate).isEmpty()) continue;
            roots.add(candidate);
        }
        return roots;
    }

    public Set getChildren(Object vertex) {
        return Collections.unmodifiableSet(this.outDegree.get(vertex));
    }

    public Set getParent(Object vertex) {
        return Collections.unmodifiableSet(this.inDegree.get(vertex));
    }

    private boolean hasPath(Object start, Object end) {
        if (start == end) {
            return true;
        }
        Set children = this.outDegree.get(start);
        Iterator it = children.iterator();
        while (it.hasNext()) {
            if (!this.hasPath(it.next(), end)) continue;
            return true;
        }
        return false;
    }

    public static DAG create() {
        return new DAG(new LinkedHashSetMultimap(), new LinkedHashSetMultimap());
    }

    public String toString() {
        return "OutDegree: " + this.outDegree.toString() + " InDegree: " + this.inDegree.toString();
    }

    public static void main(String[] args) {
        DAG dag = DAG.create();
        dag.addVertex("E");
        dag.addVertex("F");
        dag.addVertex("G");
        dag.addVertex("A");
        dag.addVertex("B");
        dag.addVertex("C");
        dag.addVertex("D");
        dag.addEdge("A", "B");
        dag.addEdge("B", "C");
        dag.addEdge("B", "D");
        dag.addEdge("D", "E");
        dag.addEdge("C", "E");
        dag.addEdge("F", "G");
        System.out.println(dag);
        System.out.println(dag.inDegree.keySet());
        System.out.println(dag.chain());
    }
}

