/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.api.DagApiService;
import com.alibaba.tesla.dag.api.DagCreateEdge;
import com.alibaba.tesla.dag.api.DagCreateNode;
import com.alibaba.tesla.dag.common.JsonUtil;
import com.alibaba.tesla.dag.model.domain.ParamType;
import com.alibaba.tesla.dag.model.domain.TcDag;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeType;
import com.alibaba.tesla.dag.model.domain.dagnode.DagNodeInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.ParamFromType;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DagApiServiceImpl
implements DagApiService {
    @Autowired
    TcDagNodeRepository dagNodeRepository;
    @Autowired
    TcDagRepository dagRepository;

    private Map<String, Object> toNode(DagCreateNode node) {
        DagInstNodeType type = node.getType() == null ? DagInstNodeType.NODE : node.getType();
        ArrayList inputParams = node.params == null ? new ArrayList() : node.params.entrySet().stream().map(entry -> DagNodeInputParam.builder().name((String)entry.getKey()).alias((String)entry.getKey()).value(entry.getValue()).type(ParamType.STRING).isOverWrite(true).fromType(ParamFromType.CONSTANT).from("").build()).collect(Collectors.toList());
        switch (type) {
            case DAG: {
                String appId = StringUtils.isEmpty((CharSequence)node.appId) ? "tesla" : node.appId;
                TcDag dag = this.dagRepository.findFirstByAppIdAndName(appId, node.name);
                ImmutableMap.Builder dataBuilder = new ImmutableMap.Builder().put((Object)"defId", (Object)dag.getId()).put((Object)"id", (Object)node.nodeId).put((Object)"label", (Object)node.name).put((Object)"type", (Object)DagInstNodeType.DAG.name()).put((Object)"inputParams", inputParams).put((Object)"outputParams", (Object)new JSONArray()).put((Object)"tooltip", (Object)new JSONObject());
                return ImmutableMap.of((Object)"shape", (Object)"rect", (Object)"id", (Object)node.nodeId, (Object)"label", (Object)node.name, (Object)"data", (Object)dataBuilder.build());
            }
            case NODE: {
                String appId = StringUtils.isEmpty((CharSequence)node.appId) ? "tesla" : node.appId;
                TcDagNode dagNode = this.dagNodeRepository.findFirstByAppIdAndName(appId, node.name);
                ImmutableMap.Builder dataBuilder = new ImmutableMap.Builder().put((Object)"defId", (Object)dagNode.getId()).put((Object)"id", (Object)node.nodeId).put((Object)"label", (Object)node.name).put((Object)"type", (Object)DagInstNodeType.NODE.name()).put((Object)"inputParams", inputParams).put((Object)"outputParams", (Object)new JSONArray()).put((Object)"tooltip", (Object)new JSONObject());
                if (node.maxRetryTimes != null) {
                    dataBuilder.put((Object)"maxRetryTimes", (Object)node.maxRetryTimes);
                }
                if (node.retryExpression != null) {
                    dataBuilder.put((Object)"retryExpression", (Object)node.retryExpression);
                }
                if (node.runTimeout != null) {
                    dataBuilder.put((Object)"runTimeout", (Object)node.runTimeout);
                }
                return ImmutableMap.of((Object)"shape", (Object)"rect", (Object)"id", (Object)node.nodeId, (Object)"label", (Object)node.name, (Object)"data", (Object)dataBuilder.build());
            }
        }
        return null;
    }

    @Override
    public Long create(String name, DagCreateNode preNode, DagCreateNode postNode, List<DagCreateNode> nodeList, List<DagCreateEdge> edgeList) throws Exception {
        JSONObject contentJson = JsonUtil.map("nodes", nodeList.stream().map(this::toNode).collect(Collectors.toList()), "edges", edgeList.stream().map(x -> ImmutableMap.of((Object)"shape", (Object)"QuadraticEdge", (Object)"source", (Object)x.sourceNodeId, (Object)"target", (Object)x.targetNodeId, (Object)"data", (Object)ImmutableMap.of((Object)"expression", (Object)x.expression), (Object)"style", (Object)ImmutableMap.of((Object)"endArrow", (Object)true, (Object)"stroke", (Object)"#fdad", (Object)"lineWidth", (Object)2))).collect(Collectors.toList()));
        if (preNode != null) {
            contentJson.put("__pre_node__", this.toNode(preNode));
        }
        if (postNode != null) {
            contentJson.put("__post_node__", this.toNode(postNode));
        }
        TcDag dag = TcDag.builder().appId("tesla").name(name).alias(name).content(JSONObject.toJSONString((Object)contentJson)).inputParams("[]").hasFeedback(1).hasHistory(1).description(name).entity("").notice("").creator("").modifier("").lastUpdateBy("API").exScheduleTaskId("").defaultShowHistory(1).build();
        dag.upsertByAppIdAndName();
        return dag.getId();
    }

    @Override
    public Long create(String name, List<DagCreateNode> nodeList, List<DagCreateEdge> edgeList) throws Exception {
        return this.create(name, null, null, nodeList, edgeList);
    }
}

