/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.api.DagInstApiService;
import com.alibaba.tesla.dag.api.DagInstNodeWithChildren;
import com.alibaba.tesla.dag.api.DagStartReq;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.TcDagInstNode;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.services.DagInstService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DagInstApiServiceImpl
implements DagInstApiService {
    @Autowired
    DagInstService dagInstService;
    @Autowired
    TcDagInstRepository dagInstRepository;
    @Autowired
    TcDagInstNodeRepository dagInstNodeRepository;

    @Override
    public Long start(DagStartReq req) throws Exception {
        return this.dagInstService.start(req.dagName, req.globalVariable, false);
    }

    @Override
    public void stop(Long dagInstId) throws Exception {
        this.dagInstService.stop(dagInstId);
    }

    @Override
    public void rerunStoppedExceptionDagInst(Long dagInstId) throws Exception {
        this.dagInstService.rerunStoppedExceptionDagInst(dagInstId);
    }

    @Override
    public void rerunStoppedDagInst(Long dagInstId) throws Exception {
        this.dagInstService.rerunStoppedDagInst(dagInstId);
    }

    @Override
    public void rerunExceptionDagInst(Long dagInstId) throws Exception {
        this.dagInstService.rerunExceptionDagInst(dagInstId);
    }

    @Override
    public void updateGlobalVariable(Long dagInstId, JSONObject globalVariable) throws Exception {
        this.dagInstService.updateGlobalVariable(dagInstId, globalVariable);
    }

    @Override
    public TcDagInst detail(Long dagInstId) throws Exception {
        return this.dagInstRepository.findFirstById(dagInstId);
    }

    @Override
    public List<TcDagInstNode> nodes(Long dagInstId) throws Exception {
        return this.dagInstNodeRepository.findAllByDagInstId(dagInstId);
    }

    @Override
    public JSONObject globalVariable(Long dagInstId) {
        return this.dagInstRepository.findFirstById(dagInstId).globalVariableJson();
    }

    @Override
    public TcDagInst getDagInstTopFatherDagInst(Long dagInstId) throws Exception {
        TcDagInstNode fatherDagInstNode = this.dagInstNodeRepository.findFirstBySubDagInstId(dagInstId);
        if (fatherDagInstNode == null) {
            return this.dagInstRepository.findFirstById(dagInstId);
        }
        return this.getDagInstTopFatherDagInst(fatherDagInstNode.getDagInstId());
    }

    @Override
    public List<DagInstNodeWithChildren> dagInstNodeNest(Long dagInstId) {
        List<TcDagInstNode> dagInstNodeList = this.dagInstNodeRepository.findAllByDagInstIdOrderByGmtStartAsc(dagInstId);
        return dagInstNodeList.stream().map(dagInstNode -> {
            DagInstNodeWithChildren dagInstNodeWithChildren = DagInstNodeWithChildren.builder().dagInstNode((TcDagInstNode)dagInstNode).build();
            Long subDagInstId = dagInstNode.getSubDagInstId();
            if (subDagInstId != null) {
                dagInstNodeWithChildren.setChildren(this.dagInstNodeNest(subDagInstId));
            }
            return dagInstNodeWithChildren;
        }).collect(Collectors.toList());
    }

    @Override
    public List<TcDagInst> listDagInst(DagInstStatus status) {
        return this.dagInstRepository.findAllByStatus(status.name());
    }
}

