/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.common;

import com.alibaba.tesla.dag.common.Tools;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class BeanUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);
    private static ApplicationContext context;

    public static <T> T getBean(Class<T> beanClass) {
        try {
            return (T)context.getBean(beanClass);
        }
        catch (Exception e) {
            return (T)context.getBean(Tools.toLowerCaseFirstOne(beanClass.getSimpleName()));
        }
    }

    public static <T> Map<String, T> getSubBean(Class<T> beanClass) {
        return context.getBeansOfType(beanClass);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }
}

