/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Requests {
    private static final Logger log = LoggerFactory.getLogger(Requests.class);
    private static OkHttpClient httpClient;

    private static OkHttpClient getHttpClient() {
        if (httpClient == null) {
            httpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool()).build();
        }
        return httpClient;
    }

    private static Request.Builder createRequestBuilder(String url, JSONObject params, JSONObject headers) {
        if (CollectionUtils.isEmpty((Map)params)) {
            params = new JSONObject();
        }
        if (CollectionUtils.isEmpty((Map)headers)) {
            headers = new JSONObject();
        }
        HttpUrl.Builder queryUrl = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
        for (String key : params.keySet()) {
            queryUrl.addQueryParameter(key, params.getString(key));
        }
        Request.Builder requestBuilder = new Request.Builder().url(queryUrl.build());
        for (String key : headers.keySet()) {
            requestBuilder.addHeader(key, headers.getString(key));
        }
        return requestBuilder;
    }

    public static <T> T transfer(String resp, Class<T> tClass) throws Exception {
        if (tClass == JSONObject.class || tClass == JSONArray.class) {
            return (T)JSONObject.parse((String)resp);
        }
        if (tClass == String.class) {
            return (T)resp;
        }
        throw new Exception(String.format("resp: %s \u4e0d\u652f\u6301class: %s", resp, tClass.getName()));
    }

    public static String get(String url, JSONObject params, JSONObject headers) throws IOException {
        Request.Builder requestBuilder = Requests.createRequestBuilder(url, params, headers);
        Request request = requestBuilder.get().build();
        Response response = Requests.getHttpClient().newCall(request).execute();
        assert (response.body() != null);
        return response.body().string();
    }

    public static <T> T get(String url, JSONObject params, JSONObject headers, Class<T> tClass) throws Exception {
        String resp = Requests.get(url, params, headers);
        return Requests.transfer(resp, tClass);
    }

    public static <T> T get(String url, Class<T> tClass) throws Exception {
        String resp = Requests.get(url, null, null);
        return Requests.transfer(resp, tClass);
    }

    public static String post(String url, JSONObject params, String postJson, JSONObject headers) throws IOException {
        Request.Builder requestBuilder = Requests.createRequestBuilder(url, params, headers);
        Request request = requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)postJson)).build();
        Response response = Requests.getHttpClient().newCall(request).execute();
        assert (response.body() != null);
        return response.body().string();
    }

    public static <T> T post(String url, JSONObject params, String postJson, JSONObject headers, Class<T> tClass) throws Exception {
        String resp = Requests.post(url, params, postJson, headers);
        return Requests.transfer(resp, tClass);
    }

    public static <T> T post(String url, String postJson, Class<T> tClass) throws Exception {
        String resp = Requests.post(url, new JSONObject(), postJson, new JSONObject());
        return Requests.transfer(resp, tClass);
    }

    public static String put(String url, JSONObject params, String postJson, JSONObject headers) throws IOException {
        Request.Builder requestBuilder = Requests.createRequestBuilder(url, params, headers);
        Request request = requestBuilder.put(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)postJson)).build();
        Response response = Requests.getHttpClient().newCall(request).execute();
        assert (response.body() != null);
        return response.body().string();
    }

    public static <T> T put(String url, JSONObject params, String postJson, JSONObject headers, Class<T> tClass) throws Exception {
        String resp = Requests.put(url, params, postJson, headers);
        return Requests.transfer(resp, tClass);
    }

    public static String delete(String url, JSONObject params, JSONObject headers) throws IOException {
        Request.Builder requestBuilder = Requests.createRequestBuilder(url, params, headers);
        Request request = requestBuilder.delete().build();
        Response response = Requests.getHttpClient().newCall(request).execute();
        assert (response.body() != null);
        return response.body().string();
    }

    public static <T> T delete(String url, JSONObject params, JSONObject headers, Class<T> tClass) throws Exception {
        String resp = Requests.delete(url, params, headers);
        return Requests.transfer(resp, tClass);
    }
}

