/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tesla.dag.common;

import com.alibaba.tesla.dag.common.CmdOutPut;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class RunCmd {
    public String cmd;
    public int timeout;
    private long startTime;
    private Process process;
    private BufferedReader stdoutBufferedReader;
    private BufferedReader stderrBufferedReader;
    private int status;
    private StringBuilder stdoutSb = new StringBuilder();
    private StringBuilder stderrSb = new StringBuilder();
    private long endTime;

    public RunCmd(String cmd, int timeout) {
        this.cmd = cmd;
        this.timeout = timeout;
    }

    public void start() throws IOException {
        this.startTime = System.currentTimeMillis() / 1000L;
        this.process = Runtime.getRuntime().exec(this.cmd);
        this.stdoutBufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        this.stderrBufferedReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
    }

    public void waitFor() throws IOException, InterruptedException {
        while (this.process.isAlive()) {
            if (this.timeout > 0 && System.currentTimeMillis() / 1000L - this.startTime > (long)this.timeout) {
                this.stderrSb.append(String.format("\n--- run cmd timeout; startTime: %s; timeout: %s; now: %s ---\n", this.startTime, this.timeout, System.currentTimeMillis() / 1000L));
                this.process.destroy();
            }
            this.flushOutErr();
            Thread.sleep(100L);
        }
        this.flushOutErr();
        this.status = this.process.exitValue();
        this.endTime = System.currentTimeMillis() / 1000L;
    }

    public void flushOutErr() throws IOException {
        while (this.stdoutBufferedReader.ready()) {
            this.stdoutSb.append(this.stdoutBufferedReader.readLine());
        }
        while (this.stderrBufferedReader.ready()) {
            this.stderrSb.append(this.stderrBufferedReader.readLine());
        }
    }

    public CmdOutPut runSync() throws IOException, InterruptedException {
        this.start();
        this.waitFor();
        return CmdOutPut.builder().status(this.status).stdout(this.stdoutSb.toString()).stderr(this.stderrSb.toString()).startTime(this.startTime).endTime(this.endTime).timeout(this.timeout).cmd(this.cmd).build();
    }
}

